/*
 * Decompiled with CFR 0.152.
 */
package sun.security.mscapi;

import java.io.ObjectStreamException;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.KeyException;
import java.security.KeyFactory;
import java.security.KeyRep;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import java.util.Arrays;
import sun.security.mscapi.CKey;
import sun.security.rsa.RSAPublicKeyImpl;
import sun.security.rsa.RSAUtil;
import sun.security.util.ECKeySizeParameterSpec;

public abstract class CPublicKey
extends CKey
implements PublicKey {
    private static final long serialVersionUID = -2289561342425825391L;
    protected byte[] encoding = null;

    static CPublicKey of(String string, long l, long l2, int n) {
        return CPublicKey.of(string, new CKey.NativeHandles(l, l2), n);
    }

    public static CPublicKey of(String string, CKey.NativeHandles nativeHandles, int n) {
        switch (string) {
            case "RSA": {
                return new CRSAPublicKey(nativeHandles, n);
            }
            case "EC": {
                return new CECPublicKey(nativeHandles, n);
            }
        }
        throw new AssertionError((Object)("Unsupported algorithm: " + string));
    }

    protected CPublicKey(String string, CKey.NativeHandles nativeHandles, int n) {
        super(string, nativeHandles, n);
    }

    @Override
    public String getFormat() {
        return "X.509";
    }

    protected Object writeReplace() throws ObjectStreamException {
        return new KeyRep(KeyRep.Type.PUBLIC, this.getAlgorithm(), this.getFormat(), this.getEncoded());
    }

    native byte[] getPublicKeyBlob(long var1, long var3) throws KeyException;

    public static class CRSAPublicKey
    extends CPublicKey
    implements RSAPublicKey {
        private BigInteger modulus = null;
        private BigInteger exponent = null;
        private static final long serialVersionUID = 12L;

        CRSAPublicKey(CKey.NativeHandles nativeHandles, int n) {
            super("RSA", nativeHandles, n);
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.algorithm + "PublicKey [size=").append(this.keyLength).append(" bits, type=");
            if (this.handles.hCryptKey != 0L) {
                stringBuffer.append(CRSAPublicKey.getKeyType(this.handles.hCryptKey)).append(", container=").append(CRSAPublicKey.getContainerName(this.handles.hCryptProv));
            } else {
                stringBuffer.append("CNG");
            }
            stringBuffer.append("]\n  modulus: ").append(this.getModulus()).append("\n  public exponent: ").append(this.getPublicExponent());
            return stringBuffer.toString();
        }

        @Override
        public BigInteger getPublicExponent() {
            if (this.exponent == null) {
                try {
                    byte[] byArray = this.getPublicKeyBlob(this.handles.hCryptProv, this.handles.hCryptKey);
                    this.exponent = new BigInteger(1, this.getExponent(byArray));
                }
                catch (KeyException keyException) {
                    throw new ProviderException(keyException);
                }
            }
            return this.exponent;
        }

        @Override
        public BigInteger getModulus() {
            if (this.modulus == null) {
                try {
                    byte[] byArray = this.getPublicKeyBlob(this.handles.hCryptProv, this.handles.hCryptKey);
                    this.modulus = new BigInteger(1, this.getModulus(byArray));
                }
                catch (KeyException keyException) {
                    throw new ProviderException(keyException);
                }
            }
            return this.modulus;
        }

        @Override
        public byte[] getEncoded() {
            if (this.encoding == null) {
                try {
                    this.encoding = RSAPublicKeyImpl.newKey(RSAUtil.KeyType.RSA, null, this.getModulus(), this.getPublicExponent()).getEncoded();
                }
                catch (KeyException keyException) {
                    // empty catch block
                }
            }
            return this.encoding;
        }

        private native byte[] getExponent(byte[] var1) throws KeyException;

        private native byte[] getModulus(byte[] var1) throws KeyException;
    }

    public static class CECPublicKey
    extends CPublicKey
    implements ECPublicKey {
        private ECPoint w = null;
        private static final long serialVersionUID = 12L;

        CECPublicKey(CKey.NativeHandles nativeHandles, int n) {
            super("EC", nativeHandles, n);
        }

        @Override
        public ECPoint getW() {
            if (this.w == null) {
                try {
                    byte[] byArray = this.getPublicKeyBlob(this.handles.hCryptProv, this.handles.hCryptKey);
                    int n = byArray[8] & 0xFF;
                    byte[] byArray2 = Arrays.copyOfRange(byArray, 8, 8 + n);
                    byte[] byArray3 = Arrays.copyOfRange(byArray, 8 + n, 8 + n + n);
                    this.w = new ECPoint(new BigInteger(1, byArray2), new BigInteger(1, byArray3));
                }
                catch (KeyException keyException) {
                    throw new ProviderException(keyException);
                }
            }
            return this.w;
        }

        @Override
        public byte[] getEncoded() {
            if (this.encoding == null) {
                try {
                    this.encoding = KeyFactory.getInstance("EC").generatePublic(new ECPublicKeySpec(this.getW(), this.getParams())).getEncoded();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return this.encoding;
        }

        @Override
        public ECParameterSpec getParams() {
            try {
                AlgorithmParameters algorithmParameters = AlgorithmParameters.getInstance("EC");
                algorithmParameters.init(new ECKeySizeParameterSpec(this.keyLength));
                return algorithmParameters.getParameterSpec(ECParameterSpec.class);
            }
            catch (Exception exception) {
                throw new ProviderException(exception);
            }
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.algorithm + "PublicKey [size=").append(this.keyLength).append("]\n  ECPoint: ").append(this.getW()).append("\n  params: ").append(this.getParams());
            return stringBuffer.toString();
        }
    }
}

