/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.utilities;

import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.utilities.Assert;
import sun.jvm.hotspot.utilities.BitMapClosure;
import sun.jvm.hotspot.utilities.Bits;

public class BitMap {
    private int size;
    private int[] data;
    private static final int bitsPerWord = 32;
    private static final int bytesPerWord = 4;

    public BitMap(int sizeInBits) {
        this.size = sizeInBits;
        int nofWords = this.sizeInWords();
        this.data = new int[nofWords];
    }

    public int size() {
        return this.size;
    }

    public boolean at(int offset) {
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(offset >= 0 && offset < this.size(), "BitMap index out of bounds");
        }
        return Bits.isSetNthBit(this.wordFor(offset), offset % 32);
    }

    public void atPut(int offset, boolean value) {
        int index = this.indexFor(offset);
        int pos = offset % 32;
        this.data[index] = value ? Bits.setNthBit(this.data[index], pos) : Bits.clearNthBit(this.data[index], pos);
    }

    public void set_size(int value) {
        this.size = value;
    }

    public void set_map(Address addr) {
        for (int i = 0; i < this.sizeInWords(); ++i) {
            this.data[i] = (int)addr.getCIntegerAt(0L, 4L, true);
            addr = addr.addOffsetTo(4L);
        }
    }

    public void clear() {
        for (int i = 0; i < this.sizeInWords(); ++i) {
            this.data[i] = 0;
        }
    }

    public void iterate(BitMapClosure blk) {
        for (int index = 0; index < this.sizeInWords(); ++index) {
            int rest = this.data[index];
            int offset = index * 32;
            while (rest != 0) {
                if (rest % 2 == 1) {
                    if (offset < this.size()) {
                        blk.doBit(offset);
                    } else {
                        return;
                    }
                }
                rest >>>= 1;
                ++offset;
            }
        }
    }

    public boolean setUnion(BitMap other) {
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(this.size() == other.size(), "must have same size");
        }
        boolean changed = false;
        for (int index = 0; index < this.sizeInWords(); ++index) {
            int temp = this.data[index] | other.data[index];
            changed = changed || temp != this.data[index];
            this.data[index] = temp;
        }
        return changed;
    }

    public void setIntersection(BitMap other) {
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(this.size() == other.size(), "must have same size");
        }
        for (int index = 0; index < this.sizeInWords(); ++index) {
            this.data[index] = this.data[index] & other.data[index];
        }
    }

    public void setFrom(BitMap other) {
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(this.size() == other.size(), "must have same size");
        }
        for (int index = 0; index < this.sizeInWords(); ++index) {
            this.data[index] = other.data[index];
        }
    }

    public boolean setDifference(BitMap other) {
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(this.size() == other.size(), "must have same size");
        }
        boolean changed = false;
        for (int index = 0; index < this.sizeInWords(); ++index) {
            int temp = this.data[index] & ~other.data[index];
            changed = changed || temp != this.data[index];
            this.data[index] = temp;
        }
        return changed;
    }

    public boolean isSame(BitMap other) {
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(this.size() == other.size(), "must have same size");
        }
        for (int index = 0; index < this.sizeInWords(); ++index) {
            if (this.data[index] == other.data[index]) continue;
            return false;
        }
        return true;
    }

    public int getNextOneOffset(int l_offset, int r_offset) {
        if (l_offset == r_offset) {
            return l_offset;
        }
        int index = this.indexFor(l_offset);
        int r_index = this.indexFor(r_offset);
        int res_offset = l_offset;
        int pos = this.bitInWord(res_offset);
        int res = this.data[index] >> pos;
        if (res != 0) {
            while ((res & 1) == 0) {
                res >>= 1;
                ++res_offset;
            }
            return res_offset;
        }
        ++index;
        while (index < r_index) {
            res = this.data[index];
            if (res != 0) {
                res_offset = index * 32;
                while ((res & 1) == 0) {
                    res >>= 1;
                    ++res_offset;
                }
                return res_offset;
            }
            ++index;
        }
        return r_offset;
    }

    private int sizeInWords() {
        return (this.size() + 32 - 1) / 32;
    }

    private int indexFor(int offset) {
        return offset / 32;
    }

    private int wordFor(int offset) {
        return this.data[offset / 32];
    }

    private int bitInWord(int offset) {
        return offset & 0x1F;
    }
}

