/*
 * Decompiled with CFR 0.152.
 */
package sun.security.pkcs11;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyGeneratorSpi;
import javax.crypto.SecretKey;
import sun.security.internal.spec.TlsRsaPremasterSecretParameterSpec;
import sun.security.pkcs11.P11Key;
import sun.security.pkcs11.Session;
import sun.security.pkcs11.Token;
import sun.security.pkcs11.wrapper.CK_ATTRIBUTE;
import sun.security.pkcs11.wrapper.CK_MECHANISM;
import sun.security.pkcs11.wrapper.CK_VERSION;
import sun.security.pkcs11.wrapper.PKCS11Exception;

final class P11TlsRsaPremasterSecretGenerator
extends KeyGeneratorSpi {
    private static final String MSG = "TlsRsaPremasterSecretGenerator must be initialized using a TlsRsaPremasterSecretParameterSpec";
    private final Token token;
    private final String algorithm;
    private long mechanism;
    private int version;
    private TlsRsaPremasterSecretParameterSpec spec;

    P11TlsRsaPremasterSecretGenerator(Token token, String string, long l) throws PKCS11Exception {
        this.token = token;
        this.algorithm = string;
        this.mechanism = l;
    }

    @Override
    protected void engineInit(SecureRandom secureRandom) {
        throw new InvalidParameterException(MSG);
    }

    @Override
    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        if (!(algorithmParameterSpec instanceof TlsRsaPremasterSecretParameterSpec)) {
            throw new InvalidAlgorithmParameterException(MSG);
        }
        this.spec = (TlsRsaPremasterSecretParameterSpec)algorithmParameterSpec;
        this.version = this.spec.getMajorVersion() << 8 | this.spec.getMinorVersion();
        if (this.version < 768 && this.version > 771) {
            throw new InvalidAlgorithmParameterException("Only SSL 3.0, TLS 1.0, TLS 1.1, and TLS 1.2 are supported");
        }
    }

    @Override
    protected void engineInit(int n, SecureRandom secureRandom) {
        throw new InvalidParameterException(MSG);
    }

    @Override
    protected SecretKey engineGenerateKey() {
        if (this.spec == null) {
            throw new IllegalStateException("TlsRsaPremasterSecretGenerator must be initialized");
        }
        CK_VERSION cK_VERSION = new CK_VERSION(this.spec.getMajorVersion(), this.spec.getMinorVersion());
        Session session = null;
        try {
            SecretKey secretKey;
            session = this.token.getObjSession();
            CK_ATTRIBUTE[] cK_ATTRIBUTEArray = this.token.getAttributes("generate", 4L, 16L, new CK_ATTRIBUTE[0]);
            long l = this.token.p11.C_GenerateKey(session.id(), new CK_MECHANISM(this.mechanism, cK_VERSION), cK_ATTRIBUTEArray);
            SecretKey secretKey2 = secretKey = P11Key.secretKey(session, l, "TlsRsaPremasterSecret", 384, cK_ATTRIBUTEArray);
            return secretKey2;
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new ProviderException("Could not generate premaster secret", pKCS11Exception);
        }
        finally {
            this.token.releaseSession(session);
        }
    }
}

