/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.tools.packager.windows;

import com.oracle.tools.packager.AbstractBundler;
import com.oracle.tools.packager.BundlerParamInfo;
import com.oracle.tools.packager.ConfigException;
import com.oracle.tools.packager.IOUtils;
import com.oracle.tools.packager.Log;
import com.oracle.tools.packager.RelativeFileSet;
import com.oracle.tools.packager.StandardBundlerParam;
import com.oracle.tools.packager.UnsupportedPlatformException;
import com.oracle.tools.packager.windows.WinAppBundler;
import com.oracle.tools.packager.windows.WinResources;
import com.oracle.tools.packager.windows.WinServiceBundler;
import com.oracle.tools.packager.windows.WindowsBundlerParam;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class WinMsiBundler
extends AbstractBundler {
    private static final ResourceBundle I18N = ResourceBundle.getBundle(WinMsiBundler.class.getName());
    public static final BundlerParamInfo<WinAppBundler> APP_BUNDLER = new WindowsBundlerParam<WinAppBundler>(I18N.getString("param.app-bundler.name"), I18N.getString("param.app-bundler.description"), "win.app.bundler", WinAppBundler.class, map -> new WinAppBundler(), null);
    public static final BundlerParamInfo<WinServiceBundler> SERVICE_BUNDLER = new WindowsBundlerParam<WinServiceBundler>(I18N.getString("param.service-bundler.name"), I18N.getString("param.service-bundler.description"), "win.service.bundler", WinServiceBundler.class, map -> new WinServiceBundler(), null);
    public static final BundlerParamInfo<Boolean> CAN_USE_WIX36 = new WindowsBundlerParam<Boolean>(I18N.getString("param.can-use-wix36.name"), I18N.getString("param.can-use-wix36.description"), "win.msi.canUseWix36", Boolean.class, map -> false, (string, map) -> Boolean.valueOf(string));
    public static final BundlerParamInfo<File> CONFIG_ROOT = new WindowsBundlerParam<File>(I18N.getString("param.config-root.name"), I18N.getString("param.config-root.description"), "configRoot", File.class, map -> {
        File file = new File((File)WindowsBundlerParam.BUILD_ROOT.fetchFrom((Map<String, ? super Object>)map), "windows");
        file.mkdirs();
        return file;
    }, (string, map) -> null);
    public static final BundlerParamInfo<File> MSI_IMAGE_DIR = new WindowsBundlerParam<File>(I18N.getString("param.image-dir.name"), I18N.getString("param.image-dir.description"), "win.msi.imageDir", File.class, map -> {
        File file = (File)IMAGES_ROOT.fetchFrom((Map<String, ? super Object>)map);
        if (!file.exists()) {
            file.mkdirs();
        }
        return new File(file, "win-msi.image");
    }, (string, map) -> null);
    public static final BundlerParamInfo<File> WIN_APP_IMAGE = new WindowsBundlerParam<File>(I18N.getString("param.app-dir.name"), I18N.getString("param.app-dir.description"), "win.app.image", File.class, null, (string, map) -> null);
    public static final StandardBundlerParam<Boolean> MSI_SYSTEM_WIDE = new StandardBundlerParam<Boolean>(I18N.getString("param.system-wide.name"), I18N.getString("param.system-wide.description"), "win.msi.systemWide", Boolean.class, map -> map.containsKey(WindowsBundlerParam.SYSTEM_WIDE.getID()) ? (Boolean)WindowsBundlerParam.SYSTEM_WIDE.fetchFrom((Map<String, ? super Object>)map) : Boolean.valueOf(true), (string, map) -> string == null || "null".equalsIgnoreCase((String)string) ? null : Boolean.valueOf(string));
    public static final StandardBundlerParam<String> PRODUCT_VERSION = new StandardBundlerParam<String>(I18N.getString("param.product-version.name"), I18N.getString("param.product-version.description"), "win.msi.productVersion", String.class, WindowsBundlerParam.VERSION::fetchFrom, (string, map) -> string);
    public static final BundlerParamInfo<UUID> UPGRADE_UUID = new WindowsBundlerParam<UUID>(I18N.getString("param.upgrade-uuid.name"), I18N.getString("param.upgrade-uuid.description"), "win.msi.upgradeUUID", UUID.class, map -> UUID.randomUUID(), (string, map) -> UUID.fromString(string));
    private static final String TOOL_CANDLE = "candle.exe";
    private static final String TOOL_LIGHT = "light.exe";
    private static final String AUTODETECT_DIRS = ";C:\\Program Files (x86)\\WiX Toolset v3.9\\bin;C:\\Program Files\\WiX Toolset v3.9\\bin;C:\\Program Files (x86)\\WiX Toolset v3.8\\bin;C:\\Program Files\\WiX Toolset v3.8\\bin;C:\\Program Files (x86)\\WiX Toolset v3.7\\bin;C:\\Program Files\\WiX Toolset v3.7\\bin";
    public static final BundlerParamInfo<String> TOOL_CANDLE_EXECUTABLE = new WindowsBundlerParam<String>(I18N.getString("param.candle-path.name"), I18N.getString("param.candle-path.description"), "win.msi.candle.exe", String.class, map -> {
        for (String string : (System.getenv("PATH") + AUTODETECT_DIRS).split(";")) {
            File file = new File(string.replace("\"", ""), TOOL_CANDLE);
            if (!file.isFile()) continue;
            return file.toString();
        }
        return null;
    }, null);
    public static final BundlerParamInfo<String> TOOL_LIGHT_EXECUTABLE = new WindowsBundlerParam<String>(I18N.getString("param.light-path.name"), I18N.getString("param.light-path.description"), "win.msi.light.exe", String.class, map -> {
        for (String string : (System.getenv("PATH") + AUTODETECT_DIRS).split(";")) {
            File file = new File(string.replace("\"", ""), TOOL_LIGHT);
            if (!file.isFile()) continue;
            return file.toString();
        }
        return null;
    }, null);
    private int id;
    private int compId;
    private static final String LAUNCHER_ID = "LauncherId";
    private static final String LAUNCHER_SVC_ID = "LauncherSvcId";
    private static final String TWEAK_FOR_EXCLUDING_LICENSE = "     <Publish Dialog=\"WelcomeDlg\" Control=\"Next\"              Event=\"NewDialog\" Value=\"InstallDirDlg\" Order=\"2\"> 1     </Publish>\n     <Publish Dialog=\"InstallDirDlg\" Control=\"Back\"              Event=\"NewDialog\" Value=\"WelcomeDlg\" Order=\"2\"> 1     </Publish>\n";
    private static final String MSI_PROJECT_TEMPLATE = "template.wxs";
    private static final String MSI_PROJECT_CONTENT_FILE = "bundle.wxi";

    public WinMsiBundler() {
        this.baseResourceLoader = WinResources.class;
    }

    @Override
    public String getName() {
        return I18N.getString("bundler.name");
    }

    @Override
    public String getDescription() {
        return I18N.getString("bundler.description");
    }

    @Override
    public String getID() {
        return "msi";
    }

    @Override
    public String getBundleType() {
        return "INSTALLER";
    }

    @Override
    public Collection<BundlerParamInfo<?>> getBundleParameters() {
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        linkedHashSet.addAll(WinAppBundler.getAppBundleParameters());
        linkedHashSet.addAll(WinMsiBundler.getMsiBundleParameters());
        return linkedHashSet;
    }

    public static Collection<BundlerParamInfo<?>> getMsiBundleParameters() {
        return Arrays.asList(StandardBundlerParam.DESCRIPTION, WindowsBundlerParam.MENU_GROUP, WindowsBundlerParam.MENU_HINT, PRODUCT_VERSION, WindowsBundlerParam.SHORTCUT_HINT, WindowsBundlerParam.SYSTEM_WIDE, WindowsBundlerParam.VENDOR, WindowsBundlerParam.LICENSE_FILE, WindowsBundlerParam.INSTALLDIR_CHOOSER);
    }

    @Override
    public File execute(Map<String, ? super Object> map, File file) {
        return this.bundle(map, file);
    }

    private static double findToolVersion(String string) {
        try {
            if (string == null || "".equals(string)) {
                return 0.0;
            }
            ProcessBuilder processBuilder = new ProcessBuilder(string, "/?");
            VersionExtractor versionExtractor = new VersionExtractor();
            IOUtils.exec(processBuilder, Log.isDebug(), true, versionExtractor);
            double d = versionExtractor.getVersion();
            Log.verbose(MessageFormat.format(I18N.getString("message.tool-version"), string, d));
            return d;
        }
        catch (Exception exception) {
            if (Log.isDebug()) {
                Log.verbose(exception);
            }
            return 0.0;
        }
    }

    @Override
    public boolean validate(Map<String, ? super Object> map) throws UnsupportedPlatformException, ConfigException {
        try {
            String string;
            if (map == null) {
                throw new ConfigException(I18N.getString("error.parameters-null"), I18N.getString("error.parameters-null.advice"));
            }
            APP_BUNDLER.fetchFrom(map).doValidate(map);
            if (((Boolean)StandardBundlerParam.SERVICE_HINT.fetchFrom(map)).booleanValue()) {
                SERVICE_BUNDLER.fetchFrom(map).validate(map);
            }
            double d = WinMsiBundler.findToolVersion(TOOL_CANDLE_EXECUTABLE.fetchFrom(map));
            double d2 = WinMsiBundler.findToolVersion(TOOL_LIGHT_EXECUTABLE.fetchFrom(map));
            double d3 = 3.0;
            boolean bl = false;
            if (d < d3) {
                Log.verbose(MessageFormat.format(I18N.getString("message.wrong-tool-version"), TOOL_CANDLE, d, d3));
                bl = true;
            }
            if (d2 < d3) {
                Log.verbose(MessageFormat.format(I18N.getString("message.wrong-tool-version"), TOOL_LIGHT, d2, d3));
                bl = true;
            }
            if (bl) {
                throw new ConfigException(I18N.getString("error.no-wix-tools"), I18N.getString("error.no-wix-tools.advice"));
            }
            if (d2 >= (double)3.6f) {
                Log.verbose(I18N.getString("message.use-wix36-features"));
                map.put(CAN_USE_WIX36.getID(), Boolean.TRUE);
            }
            if (!WinMsiBundler.isVersionStringValid(string = (String)PRODUCT_VERSION.fetchFrom(map))) {
                throw new ConfigException(MessageFormat.format(I18N.getString("error.version-string-wrong-format"), string), MessageFormat.format(I18N.getString("error.version-string-wrong-format.advice"), PRODUCT_VERSION.getID()));
            }
            List list = (List)WindowsBundlerParam.FILE_ASSOCIATIONS.fetchFrom(map);
            if (list != null) {
                for (int i = 0; i < list.size(); ++i) {
                    Map map2 = (Map)list.get(i);
                    Object object = (List)WindowsBundlerParam.FA_CONTENT_TYPE.fetchFrom(map2);
                    if (object.size() <= 1) continue;
                    throw new ConfigException(MessageFormat.format(I18N.getString("error.too-many-content-types-for-file-association"), i), I18N.getString("error.too-many-content-types-for-file-association.advice"));
                }
            }
            if (map.containsKey(WindowsBundlerParam.LICENSE_FILE.getID())) {
                List list2 = (List)WindowsBundlerParam.APP_RESOURCES_LIST.fetchFrom(map);
                for (Object object : (List)WindowsBundlerParam.LICENSE_FILE.fetchFrom(map)) {
                    boolean bl2 = false;
                    for (RelativeFileSet relativeFileSet : list2) {
                        bl2 = bl2 || relativeFileSet.contains((String)object);
                    }
                    if (bl2) continue;
                    throw new ConfigException(I18N.getString("error.license-missing"), MessageFormat.format(I18N.getString("error.license-missing.advice"), object));
                }
            }
            return true;
        }
        catch (RuntimeException runtimeException) {
            if (runtimeException.getCause() instanceof ConfigException) {
                throw (ConfigException)runtimeException.getCause();
            }
            throw new ConfigException(runtimeException);
        }
    }

    static boolean isVersionStringValid(String string) {
        if (string == null) {
            return true;
        }
        String[] stringArray = string.split("\\.");
        if (stringArray.length > 3) {
            Log.verbose(I18N.getString("message.version-string-too-many-components"));
            return false;
        }
        try {
            int n = Integer.parseInt(stringArray[0]);
            if (n < 0 || n > 255) {
                Log.verbose(I18N.getString("error.version-string-major-out-of-range"));
                return false;
            }
            if (stringArray.length > 1 && ((n = Integer.parseInt(stringArray[1])) < 0 || n > 255)) {
                Log.verbose(I18N.getString("error.version-string-minor-out-of-range"));
                return false;
            }
            if (stringArray.length > 2 && ((n = Integer.parseInt(stringArray[2])) < 0 || n > 65535)) {
                Log.verbose(I18N.getString("error.version-string-build-out-of-range"));
                return false;
            }
        }
        catch (NumberFormatException numberFormatException) {
            Log.verbose(I18N.getString("error.version-string-part-not-number"));
            Log.verbose(numberFormatException);
            return false;
        }
        return true;
    }

    private boolean prepareProto(Map<String, ? super Object> map) throws IOException {
        File file;
        Object object2;
        List list;
        File file2 = MSI_IMAGE_DIR.fetchFrom(map);
        File file3 = APP_BUNDLER.fetchFrom(map).doBundle(map, file2, true);
        map.put(WIN_APP_IMAGE.getID(), file3);
        if (((Boolean)StandardBundlerParam.SERVICE_HINT.fetchFrom(map)).booleanValue() && file3 != null) {
            file3 = SERVICE_BUNDLER.fetchFrom(map).doBundle(map, file3, true);
        }
        if ((list = (List)WindowsBundlerParam.LICENSE_FILE.fetchFrom(map)) != null) {
            block2: for (Object object2 : (List)WindowsBundlerParam.APP_RESOURCES_LIST.fetchFrom(map)) {
                for (Object object3 : list) {
                    if (!((RelativeFileSet)object2).contains((String)object3)) continue;
                    file = new File(((RelativeFileSet)object2).getBaseDirectory(), (String)object3);
                    File file4 = new File(file3, file.getName());
                    IOUtils.copyFile(file, file4);
                    WinMsiBundler.ensureByMutationFileIsRTF(file4);
                    break block2;
                }
            }
        }
        List list2 = (List)WindowsBundlerParam.FILE_ASSOCIATIONS.fetchFrom(map);
        object2 = list2.iterator();
        while (object2.hasNext()) {
            Object object3;
            Map map2 = (Map)object2.next();
            object3 = (File)WindowsBundlerParam.FA_ICON.fetchFrom(map2);
            if (object3 == null) continue;
            file = new File(file3, ((File)object3).getName());
            if (!((File)object3).exists()) continue;
            try {
                IOUtils.copyFile((File)object3, file);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return file3 != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public File bundle(Map<String, ? super Object> map, File file) {
        File file2;
        block38: {
            File file3;
            if (!file.isDirectory() && !file.mkdirs()) {
                throw new RuntimeException(MessageFormat.format(I18N.getString("error.cannot-create-output-dir"), file.getAbsolutePath()));
            }
            if (!file.canWrite()) {
                throw new RuntimeException(MessageFormat.format(I18N.getString("error.cannot-write-to-output-dir"), file.getAbsolutePath()));
            }
            String string = TOOL_LIGHT_EXECUTABLE.fetchFrom(map);
            String string2 = TOOL_CANDLE_EXECUTABLE.fetchFrom(map);
            if (string == null || !new File(string).isFile() || string2 == null || !new File(string2).isFile()) {
                Log.info(I18N.getString("error.no-wix-tools"));
                Log.info(MessageFormat.format(I18N.getString("message.light-file-string"), string));
                Log.info(MessageFormat.format(I18N.getString("message.candle-file-string"), string2));
                return null;
            }
            file2 = MSI_IMAGE_DIR.fetchFrom(map);
            file2.mkdirs();
            boolean bl = (Boolean)WindowsBundlerParam.MENU_HINT.fetchFrom(map);
            boolean bl2 = (Boolean)WindowsBundlerParam.SHORTCUT_HINT.fetchFrom(map);
            if (!bl && !bl2) {
                Log.verbose(I18N.getString("message.one-shortcut-required"));
                map.put(WindowsBundlerParam.MENU_HINT.getID(), (Object)true);
            }
            if (!this.prepareProto(map) || !this.prepareWiXConfig(map) || !this.prepareBasicProjectConfig(map)) break block38;
            File file4 = this.getConfig_Script(map);
            if (file4.exists()) {
                file3 = new File(file2, file4.getName());
                IOUtils.copyFile(file4, file3);
                Log.info(MessageFormat.format(I18N.getString("message.running-wsh-script"), file3.getAbsolutePath()));
                IOUtils.run("wscript", file3, (Boolean)WindowsBundlerParam.VERBOSE.fetchFrom(map));
            }
            file3 = this.buildMSI(map, file);
            try {
                if (file2 != null && !Log.isDebug()) {
                    IOUtils.deleteRecursive(file2);
                } else if (file2 != null) {
                    Log.info(MessageFormat.format(I18N.getString("message.debug-working-directory"), file2.getAbsolutePath()));
                }
                if (((Boolean)WindowsBundlerParam.VERBOSE.fetchFrom(map)).booleanValue()) {
                    Log.info(MessageFormat.format(I18N.getString("message.config-save-location"), CONFIG_ROOT.fetchFrom(map).getAbsolutePath()));
                } else {
                    this.cleanupConfigFiles(map);
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                return null;
            }
            return file3;
        }
        File file5 = null;
        try {
            if (file2 != null && !Log.isDebug()) {
                IOUtils.deleteRecursive(file2);
            } else if (file2 != null) {
                Log.info(MessageFormat.format(I18N.getString("message.debug-working-directory"), file2.getAbsolutePath()));
            }
            if (((Boolean)WindowsBundlerParam.VERBOSE.fetchFrom(map)).booleanValue()) {
                Log.info(MessageFormat.format(I18N.getString("message.config-save-location"), CONFIG_ROOT.fetchFrom(map).getAbsolutePath()));
            } else {
                this.cleanupConfigFiles(map);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
        return file5;
        catch (IOException iOException) {
            File file6;
            try {
                Log.verbose(iOException);
                file6 = null;
            }
            catch (Throwable throwable) {
                try {
                    if (file2 != null && !Log.isDebug()) {
                        IOUtils.deleteRecursive(file2);
                    } else if (file2 != null) {
                        Log.info(MessageFormat.format(I18N.getString("message.debug-working-directory"), file2.getAbsolutePath()));
                    }
                    if (((Boolean)WindowsBundlerParam.VERBOSE.fetchFrom(map)).booleanValue()) {
                        Log.info(MessageFormat.format(I18N.getString("message.config-save-location"), CONFIG_ROOT.fetchFrom(map).getAbsolutePath()));
                    } else {
                        this.cleanupConfigFiles(map);
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                    return null;
                }
                throw throwable;
            }
            try {
                if (file2 != null && !Log.isDebug()) {
                    IOUtils.deleteRecursive(file2);
                } else if (file2 != null) {
                    Log.info(MessageFormat.format(I18N.getString("message.debug-working-directory"), file2.getAbsolutePath()));
                }
                if (((Boolean)WindowsBundlerParam.VERBOSE.fetchFrom(map)).booleanValue()) {
                    Log.info(MessageFormat.format(I18N.getString("message.config-save-location"), CONFIG_ROOT.fetchFrom(map).getAbsolutePath()));
                } else {
                    this.cleanupConfigFiles(map);
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                return null;
            }
            return file6;
        }
    }

    protected void cleanupConfigFiles(Map<String, ? super Object> map) {
        if (this.getConfig_ProjectFile(map) != null) {
            this.getConfig_ProjectFile(map).delete();
        }
        if (this.getConfig_Script(map) != null) {
            this.getConfig_Script(map).delete();
        }
    }

    private File getConfig_Script(Map<String, ? super Object> map) {
        return new File(CONFIG_ROOT.fetchFrom(map), (String)WindowsBundlerParam.APP_FS_NAME.fetchFrom(map) + "-post-image.wsf");
    }

    private boolean prepareBasicProjectConfig(Map<String, ? super Object> map) throws IOException {
        this.fetchResource("package/windows/" + this.getConfig_Script(map).getName(), I18N.getString("resource.post-install-script"), (String)null, this.getConfig_Script(map), (boolean)((Boolean)WindowsBundlerParam.VERBOSE.fetchFrom(map)), (File)WindowsBundlerParam.DROP_IN_RESOURCES_ROOT.fetchFrom(map));
        return true;
    }

    private String relativePath(File file, File file2) {
        return file2.getAbsolutePath().substring(file.getAbsolutePath().length() + 1);
    }

    boolean prepareMainProjectFile(Map<String, ? super Object> map) throws IOException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        UUID uUID = UUID.randomUUID();
        Log.verbose(MessageFormat.format(I18N.getString("message.generated-product-guid"), uUID.toString()));
        hashMap.put("PRODUCT_GUID", uUID.toString());
        hashMap.put("PRODUCT_UPGRADE_GUID", UPGRADE_UUID.fetchFrom(map).toString());
        hashMap.put("APPLICATION_NAME", (String)WindowsBundlerParam.APP_NAME.fetchFrom(map));
        hashMap.put("APPLICATION_DESCRIPTION", (String)StandardBundlerParam.DESCRIPTION.fetchFrom(map));
        hashMap.put("APPLICATION_VENDOR", (String)WindowsBundlerParam.VENDOR.fetchFrom(map));
        hashMap.put("APPLICATION_VERSION", (String)PRODUCT_VERSION.fetchFrom(map));
        File file = WIN_APP_IMAGE.fetchFrom(map);
        File file2 = new File(file, WinAppBundler.getLauncherName(map));
        String string = this.relativePath(file, file2);
        hashMap.put("APPLICATION_LAUNCHER", string);
        String string2 = string.replace(".exe", ".ico");
        hashMap.put("APPLICATION_ICON", string2);
        hashMap.put("REGISTRY_ROOT", this.getRegistryRoot(map));
        boolean bl = CAN_USE_WIX36.fetchFrom(map);
        hashMap.put("WIX36_ONLY_START", bl ? "" : "<!--");
        hashMap.put("WIX36_ONLY_END", bl ? "" : "-->");
        if (((Boolean)MSI_SYSTEM_WIDE.fetchFrom(map)).booleanValue()) {
            hashMap.put("INSTALL_SCOPE", "perMachine");
        } else {
            hashMap.put("INSTALL_SCOPE", "perUser");
        }
        if (((Boolean)WindowsBundlerParam.BIT_ARCH_64.fetchFrom(map)).booleanValue()) {
            hashMap.put("PLATFORM", "x64");
            hashMap.put("WIN64", "yes");
        } else {
            hashMap.put("PLATFORM", "x86");
            hashMap.put("WIN64", "no");
        }
        hashMap.put("UI_BLOCK", this.getUIBlock(map));
        hashMap.put("APP_CDS_BLOCK", this.getAppCDSBlock(map));
        List list = (List)WindowsBundlerParam.SECONDARY_LAUNCHERS.fetchFrom(map);
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < list.size(); ++i) {
            Map map2 = (Map)list.get(i);
            if (!((Boolean)WindowsBundlerParam.SHORTCUT_HINT.fetchFrom(map2)).booleanValue() && !((Boolean)WindowsBundlerParam.MENU_HINT.fetchFrom(map2)).booleanValue()) continue;
            File file3 = new File(file, WinAppBundler.getLauncherName(map2));
            String string3 = this.relativePath(file, file3);
            String string4 = string3.replace(".exe", ".ico");
            stringBuilder.append("        <Icon Id=\"Launcher");
            stringBuilder.append(i);
            stringBuilder.append(".exe\" SourceFile=\"");
            stringBuilder.append(string4);
            stringBuilder.append("\" />\r\n");
        }
        hashMap.put("SECONDARY_LAUNCHER_ICONS", stringBuilder.toString());
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(this.getConfig_ProjectFile(map)));
        bufferedWriter.write(this.preprocessTextResource("package/windows/" + this.getConfig_ProjectFile(map).getName(), I18N.getString("resource.wix-config-file"), MSI_PROJECT_TEMPLATE, hashMap, (Boolean)WindowsBundlerParam.VERBOSE.fetchFrom(map), (File)WindowsBundlerParam.DROP_IN_RESOURCES_ROOT.fetchFrom(map)));
        ((Writer)bufferedWriter).close();
        return true;
    }

    private String getUIBlock(Map<String, ? super Object> map) {
        String string = "     <UI/>\n";
        if (WindowsBundlerParam.INSTALLDIR_CHOOSER.fetchFrom(map).booleanValue()) {
            boolean bl = this.getLicenseFile(map) == null;
            string = "     <UI>\n     <Property Id=\"WIXUI_INSTALLDIR\" Value=\"APPLICATIONFOLDER\" />\n     <UIRef Id=\"WixUI_InstallDir\" />\n" + (bl ? TWEAK_FOR_EXCLUDING_LICENSE : "") + "     </UI>\n";
        } else if (this.getLicenseFile(map) != null) {
            string = "     <UI>\n     <UIRef Id=\"WixUI_Minimal\" />\n     </UI>\n";
        }
        return string;
    }

    private String getAppCDSBlock(Map<String, ? super Object> map) {
        String string = "";
        if (((Boolean)WindowsBundlerParam.UNLOCK_COMMERCIAL_FEATURES.fetchFrom(map)).booleanValue() && ((Boolean)WindowsBundlerParam.ENABLE_APP_CDS.fetchFrom(map)).booleanValue() && ("install".equals(WindowsBundlerParam.APP_CDS_CACHE_MODE.fetchFrom(map)) || "auto+install".equals(WindowsBundlerParam.APP_CDS_CACHE_MODE.fetchFrom(map)))) {
            string = "     <CustomAction Id=\"CACHE_CDS\"\n          Directory=\"APPLICATIONFOLDER\"\n          ExeCommand=\"[APPLICATIONFOLDER]" + WinAppBundler.getLauncherName(map) + " -Xappcds:generatecache\"\n          Execute=\"commit\"\n          Return=\"check\"/>\n\n     <InstallExecuteSequence>\n         <Custom Action=\"CACHE_CDS\" Before=\"InstallFinalize\" />\n     </InstallExecuteSequence>";
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private void walkFileTree(Map<String, ? super Object> map, File file, PrintStream printStream, String string) {
        File file2;
        Object object;
        Object object2;
        Object object3;
        File file322;
        ArrayList<File> arrayList = new ArrayList<File>();
        ArrayList<File> arrayList2 = new ArrayList<File>();
        if (!file.isDirectory()) {
            throw new RuntimeException(MessageFormat.format(I18N.getString("error.cannot-walk-directory"), file.getAbsolutePath()));
        }
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (File file322 : fileArray) {
                if (file322.isDirectory()) {
                    arrayList.add(file322);
                    continue;
                }
                arrayList2.add(file322);
            }
        }
        printStream.println(string + " <Component Id=\"comp" + this.compId++ + "\" DiskId=\"1\" Guid=\"" + UUID.randomUUID().toString() + "\"" + ((Boolean)WindowsBundlerParam.BIT_ARCH_64.fetchFrom(map) != false ? " Win64=\"yes\"" : "") + ">");
        printStream.println(string + "  <CreateFolder/>");
        printStream.println(string + "  <RemoveFolder Id=\"RemoveDir" + this.id++ + "\" On=\"uninstall\" />");
        boolean bl = (Boolean)MSI_SYSTEM_WIDE.fetchFrom(map) == false;
        File file4 = WIN_APP_IMAGE.fetchFrom(map);
        File file5 = new File(file4, WinAppBundler.getLauncherName(map));
        file322 = WinServiceBundler.getLauncherSvc(file4, map);
        for (File file6 : arrayList2) {
            boolean bl2 = file6.equals(file5);
            if (!bl2) continue;
            bl = true;
        }
        if (bl) {
            printStream.println(string + "    <RegistryKey Root=\"HKCU\"  Key=\"Software\\" + (String)WindowsBundlerParam.VENDOR.fetchFrom(map) + "\\" + (String)WindowsBundlerParam.APP_NAME.fetchFrom(map) + "\"" + (CAN_USE_WIX36.fetchFrom(map) != false ? ">" : " Action=\"createAndRemoveOnUninstall\">"));
            printStream.println(string + "     <RegistryValue Name=\"Version\" Value=\"" + (String)WindowsBundlerParam.VERSION.fetchFrom(map) + "\" Type=\"string\" KeyPath=\"yes\"/>");
            printStream.println(string + "   </RegistryKey>");
        }
        boolean bl3 = (Boolean)WindowsBundlerParam.MENU_HINT.fetchFrom(map);
        boolean bl4 = (Boolean)WindowsBundlerParam.SHORTCUT_HINT.fetchFrom(map);
        TreeMap<String, Object> treeMap = new TreeMap<String, Object>();
        boolean bl5 = false;
        for (File iterator : arrayList2) {
            boolean bl2 = iterator.equals(file5);
            boolean bl6 = iterator.equals(file322);
            if (bl6) continue;
            bl5 = bl5 || bl2;
            boolean bl7 = bl2 && (bl3 || bl4);
            object3 = bl2 ? LAUNCHER_ID : "FileId" + this.id++;
            treeMap.put(iterator.getName(), object3);
            printStream.println(string + "   <File Id=\"" + (String)object3 + "\" Name=\"" + iterator.getName() + "\"  Source=\"" + this.relativePath(file4, iterator) + "\"" + ((Boolean)WindowsBundlerParam.BIT_ARCH_64.fetchFrom(map) != false ? " ProcessorArchitecture=\"x64\"" : "") + ">");
            if (bl7 && bl4) {
                printStream.println(string + "  <Shortcut Id=\"desktopShortcut\" Directory=\"DesktopFolder\" Name=\"" + (String)WindowsBundlerParam.APP_NAME.fetchFrom(map) + "\" WorkingDirectory=\"INSTALLDIR\" Advertise=\"no\" Icon=\"DesktopIcon.exe\" IconIndex=\"0\" />");
            }
            if (bl7 && bl3) {
                printStream.println(string + "     <Shortcut Id=\"ExeShortcut\" Directory=\"ProgramMenuDir\" Name=\"" + (String)WindowsBundlerParam.APP_NAME.fetchFrom(map) + "\" Advertise=\"no\" Icon=\"StartMenuIcon.exe\" IconIndex=\"0\" />");
            }
            object2 = (List)WindowsBundlerParam.SECONDARY_LAUNCHERS.fetchFrom(map);
            for (int i = 0; i < object2.size(); ++i) {
                object = (Map)object2.get(i);
                file2 = new File(file4, WinAppBundler.getLauncherName((Map<String, ? super Object>)object));
                if (!iterator.equals(file2)) continue;
                if (((Boolean)WindowsBundlerParam.SHORTCUT_HINT.fetchFrom((Map<String, Object>)object)).booleanValue()) {
                    printStream.println(string + "  <Shortcut Id=\"desktopShortcut" + i + "\" Directory=\"DesktopFolder\" Name=\"" + (String)WindowsBundlerParam.APP_NAME.fetchFrom((Map<String, Object>)object) + "\" WorkingDirectory=\"INSTALLDIR\" Advertise=\"no\" Icon=\"Launcher" + i + ".exe\" IconIndex=\"0\" />");
                }
                if (!((Boolean)WindowsBundlerParam.MENU_HINT.fetchFrom((Map<String, Object>)object)).booleanValue()) continue;
                printStream.println(string + "     <Shortcut Id=\"ExeShortcut" + i + "\" Directory=\"ProgramMenuDir\" Name=\"" + (String)WindowsBundlerParam.APP_NAME.fetchFrom((Map<String, Object>)object) + "\" Advertise=\"no\" Icon=\"Launcher" + i + ".exe\" IconIndex=\"0\" />");
            }
            printStream.println(string + "   </File>");
        }
        if (bl5) {
            List list = (List)WindowsBundlerParam.FILE_ASSOCIATIONS.fetchFrom(map);
            String string2 = WindowsBundlerParam.APP_REGISTRY_NAME.fetchFrom(map);
            TreeSet<String> treeSet = new TreeSet<String>();
            boolean bl8 = false;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                void var19_35;
                String string3;
                object3 = (Map)iterator.next();
                object2 = (String)WindowsBundlerParam.FA_DESCRIPTION.fetchFrom((Map<String, Object>)object3);
                List list2 = (List)WindowsBundlerParam.FA_EXTENSIONS.fetchFrom((Map<String, Object>)object3);
                object = (List)WindowsBundlerParam.FA_CONTENT_TYPE.fetchFrom((Map<String, Object>)object3);
                file2 = (File)WindowsBundlerParam.FA_ICON.fetchFrom((Map<String, Object>)object3);
                String string4 = string3 = object == null || object.isEmpty() ? null : (String)object.get(0);
                if (list2 == null) {
                    Log.info(I18N.getString("message.creating-association-with-null-extension"));
                    Object object4 = string2 + "File";
                    if (var19_35 > 0) {
                        object4 = (String)object4 + "." + (int)var19_35;
                    }
                    ++var19_35;
                    printStream.print(string + "   <ProgId Id='" + (String)object4 + "' Description='" + (String)object2 + "'");
                    if (file2 != null && file2.exists()) {
                        printStream.print(" Icon='" + (String)treeMap.get(file2.getName()) + "' IconIndex='0'");
                    }
                    printStream.println(" />");
                    continue;
                }
                for (String string5 : list2) {
                    String string6 = string2 + "File";
                    if (var19_35 > 0) {
                        string6 = string6 + "." + (int)var19_35;
                    }
                    ++var19_35;
                    printStream.print(string + "   <ProgId Id='" + string6 + "' Description='" + (String)object2 + "'");
                    if (file2 != null && file2.exists()) {
                        printStream.print(" Icon='" + (String)treeMap.get(file2.getName()) + "' IconIndex='0'");
                    }
                    printStream.println(">");
                    if (list2 == null) {
                        Log.info(I18N.getString("message.creating-association-with-null-extension"));
                    } else {
                        printStream.print(string + "    <Extension Id='" + string5 + "' Advertise='no'");
                        if (string3 == null) {
                            printStream.println(">");
                        } else {
                            printStream.println(" ContentType='" + string3 + "'>");
                            if (!treeSet.contains(string3)) {
                                printStream.println(string + "      <MIME ContentType='" + string3 + "' Default='yes' />");
                                treeSet.add(string3);
                            }
                        }
                        printStream.println(string + "      <Verb Id='open' Command='Open' TargetFile='" + LAUNCHER_ID + "' Argument='\"%1\"' />");
                        printStream.println(string + "    </Extension>");
                    }
                    printStream.println(string + "   </ProgId>");
                }
            }
        }
        printStream.println(string + " </Component>");
        boolean bl8 = false;
        for (File file3 : arrayList2) {
            boolean bl9 = file3.equals(file322);
            if (!bl9 || !((Boolean)StandardBundlerParam.SERVICE_HINT.fetchFrom(map)).booleanValue()) continue;
            bl8 = true;
        }
        if (bl8) {
            printStream.println(string + " <Component Id=\"comp" + this.compId++ + "\" DiskId=\"1\" Guid=\"" + UUID.randomUUID().toString() + "\"" + ((Boolean)WindowsBundlerParam.BIT_ARCH_64.fetchFrom(map) != false ? " Win64=\"yes\"" : "") + ">");
            printStream.println("  <CreateFolder/>");
            printStream.println("  <RemoveFolder Id=\"RemoveDir" + this.id++ + "\" On=\"uninstall\" />");
            printStream.println(string + "   <File Id=\"" + LAUNCHER_SVC_ID + "\" Name=\"" + file322.getName() + "\"  Source=\"" + this.relativePath(file4, file322) + "\"" + ((Boolean)WindowsBundlerParam.BIT_ARCH_64.fetchFrom(map) != false ? " ProcessorArchitecture=\"x64\"" : "") + " KeyPath=\"yes\">");
            printStream.println(string + "   </File>");
            printStream.println(string + "   <ServiceInstall Id=\"" + (String)WindowsBundlerParam.APP_FS_NAME.fetchFrom(map) + "\" Name=\"" + (String)WindowsBundlerParam.APP_NAME.fetchFrom(map) + "\" Description=\"" + (String)StandardBundlerParam.DESCRIPTION.fetchFrom(map) + "\" ErrorControl=\"normal\" Start=\"" + ((Boolean)StandardBundlerParam.RUN_AT_STARTUP.fetchFrom(map) != false ? "auto" : "demand") + "\" Type=\"ownProcess\" Vital=\"yes\" Account=\"LocalSystem\" Arguments='-mainExe \"" + file5.getName() + "\"'/>");
            printStream.println(string + "   <ServiceControl Id=\"" + (String)WindowsBundlerParam.APP_FS_NAME.fetchFrom(map) + "\" Name=\"" + (String)WindowsBundlerParam.APP_NAME.fetchFrom(map) + "\"" + ((Boolean)StandardBundlerParam.START_ON_INSTALL.fetchFrom(map) != false ? " Start=\"install\"" : "") + ((Boolean)StandardBundlerParam.STOP_ON_UNINSTALL.fetchFrom(map) != false ? " Stop=\"uninstall\"" : "") + " Remove=\"uninstall\" Wait=\"yes\" />");
            printStream.println(string + " </Component>");
        }
        for (File file6 : arrayList) {
            printStream.println(string + " <Directory Id=\"dirid" + this.id++ + "\" Name=\"" + file6.getName() + "\">");
            this.walkFileTree(map, file6, printStream, string + " ");
            printStream.println(string + " </Directory>");
        }
    }

    String getRegistryRoot(Map<String, ? super Object> map) {
        if (((Boolean)MSI_SYSTEM_WIDE.fetchFrom(map)).booleanValue()) {
            return "HKLM";
        }
        return "HKCU";
    }

    boolean prepareContentList(Map<String, ? super Object> map) throws FileNotFoundException {
        File file = new File(CONFIG_ROOT.fetchFrom(map), MSI_PROJECT_CONTENT_FILE);
        PrintStream printStream = new PrintStream(file);
        printStream.println("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>");
        printStream.println("<Include>");
        printStream.println(" <Directory Id=\"TARGETDIR\" Name=\"SourceDir\">");
        if (((Boolean)MSI_SYSTEM_WIDE.fetchFrom(map)).booleanValue()) {
            if (((Boolean)WindowsBundlerParam.BIT_ARCH_64.fetchFrom(map)).booleanValue()) {
                printStream.println("  <Directory Id=\"ProgramFiles64Folder\" Name=\"PFiles\">");
            } else {
                printStream.println("  <Directory Id=\"ProgramFilesFolder\" Name=\"PFiles\">");
            }
        } else {
            printStream.println("  <Directory Name=\"AppData\" Id=\"LocalAppDataFolder\">");
        }
        printStream.println("   <Directory Id=\"APPLICATIONFOLDER\" Name=\"" + (String)WindowsBundlerParam.APP_NAME.fetchFrom(map) + "\">");
        this.id = 0;
        this.compId = 0;
        this.walkFileTree(map, WIN_APP_IMAGE.fetchFrom(map), printStream, "    ");
        printStream.println("   </Directory>");
        printStream.println("  </Directory>");
        if (((Boolean)WindowsBundlerParam.SHORTCUT_HINT.fetchFrom(map)).booleanValue()) {
            printStream.println("  <Directory Id=\"DesktopFolder\" />");
        }
        if (((Boolean)WindowsBundlerParam.MENU_HINT.fetchFrom(map)).booleanValue()) {
            printStream.println("  <Directory Id=\"ProgramMenuFolder\">");
            printStream.println("    <Directory Id=\"ProgramMenuDir\" Name=\"" + (String)WindowsBundlerParam.MENU_GROUP.fetchFrom(map) + "\">");
            printStream.println("      <Component Id=\"comp" + this.compId++ + "\" Guid=\"" + UUID.randomUUID().toString() + "\"" + ((Boolean)WindowsBundlerParam.BIT_ARCH_64.fetchFrom(map) != false ? " Win64=\"yes\"" : "") + ">");
            printStream.println("        <RemoveFolder Id=\"ProgramMenuDir\" On=\"uninstall\" />");
            printStream.println("         <RegistryValue Root=\"HKCU\" Key=\"Software\\" + (String)WindowsBundlerParam.VENDOR.fetchFrom(map) + "\\" + (String)WindowsBundlerParam.APP_NAME.fetchFrom(map) + "\" Type=\"string\" Value=\"\" />");
            printStream.println("      </Component>");
            printStream.println("    </Directory>");
            printStream.println(" </Directory>");
        }
        printStream.println(" </Directory>");
        printStream.println(" <Feature Id=\"DefaultFeature\" Title=\"Main Feature\" Level=\"1\">");
        for (int i = 0; i < this.compId; ++i) {
            printStream.println("    <ComponentRef Id=\"comp" + i + "\" />");
        }
        printStream.println("    <ComponentRef Id=\"CleanupMainApplicationFolder\" />");
        printStream.println(" </Feature>");
        printStream.println("</Include>");
        printStream.close();
        return true;
    }

    private File getConfig_ProjectFile(Map<String, ? super Object> map) {
        return new File(CONFIG_ROOT.fetchFrom(map), (String)WindowsBundlerParam.APP_NAME.fetchFrom(map) + ".wxs");
    }

    private String getLicenseFile(Map<String, ? super Object> map) {
        List list = (List)WindowsBundlerParam.LICENSE_FILE.fetchFrom(map);
        if (list == null || list.isEmpty()) {
            return null;
        }
        return (String)list.get(0);
    }

    private boolean prepareWiXConfig(Map<String, ? super Object> map) throws IOException {
        return this.prepareMainProjectFile(map) && this.prepareContentList(map);
    }

    private File buildMSI(Map<String, ? super Object> map, File file) throws IOException {
        File file2 = new File((File)WindowsBundlerParam.BUILD_ROOT.fetchFrom(map), "tmp");
        File file3 = new File(file2, (String)WindowsBundlerParam.APP_NAME.fetchFrom(map) + ".wixobj");
        File file4 = new File(file, WindowsBundlerParam.INSTALLER_FILE_NAME.fetchFrom(map) + ".msi");
        Log.verbose(MessageFormat.format(I18N.getString("message.preparing-msi-config"), file4.getAbsolutePath()));
        file4.getParentFile().mkdirs();
        ProcessBuilder processBuilder = new ProcessBuilder(TOOL_CANDLE_EXECUTABLE.fetchFrom(map), "-nologo", this.getConfig_ProjectFile(map).getAbsolutePath(), "-ext", "WixUtilExtension", "-out", file3.getAbsolutePath());
        processBuilder = processBuilder.directory(WIN_APP_IMAGE.fetchFrom(map));
        IOUtils.exec(processBuilder, (Boolean)WindowsBundlerParam.VERBOSE.fetchFrom(map));
        Log.verbose(MessageFormat.format(I18N.getString("message.generating-msi"), file4.getAbsolutePath()));
        boolean bl = this.getLicenseFile(map) != null;
        boolean bl2 = WindowsBundlerParam.INSTALLDIR_CHOOSER.fetchFrom(map);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(TOOL_LIGHT_EXECUTABLE.fetchFrom(map));
        if (bl) {
            arrayList.add("-dWixUILicenseRtf=" + this.getLicenseFile(map));
        }
        arrayList.add("-nologo");
        arrayList.add("-spdb");
        arrayList.add("-sice:60");
        arrayList.add(file3.getAbsolutePath());
        arrayList.add("-ext");
        arrayList.add("WixUtilExtension");
        if (bl || bl2) {
            arrayList.add("-ext");
            arrayList.add("WixUIExtension.dll");
        }
        arrayList.add("-out");
        arrayList.add(file4.getAbsolutePath());
        processBuilder = new ProcessBuilder(arrayList);
        processBuilder = processBuilder.directory(WIN_APP_IMAGE.fetchFrom(map));
        IOUtils.exec(processBuilder, (Boolean)WindowsBundlerParam.VERBOSE.fetchFrom(map));
        file3.delete();
        IOUtils.deleteRecursive(file2);
        return file4;
    }

    public static void ensureByMutationFileIsRTF(File file) {
        block29: {
            if (file == null || !file.isFile()) {
                return;
            }
            try {
                Object object;
                boolean bl = false;
                Object object2 = new FileInputStream(file);
                Object object3 = null;
                try {
                    object = new byte[7];
                    if (((FileInputStream)object2).read((byte[])object) == ((byte[])object).length) {
                        String string = new String((byte[])object);
                        bl = "{\\rtf1\\".equals(string);
                    }
                }
                catch (Throwable throwable) {
                    object3 = throwable;
                    throw throwable;
                }
                finally {
                    if (object2 != null) {
                        if (object3 != null) {
                            try {
                                ((FileInputStream)object2).close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object3).addSuppressed(throwable);
                            }
                        } else {
                            ((FileInputStream)object2).close();
                        }
                    }
                }
                if (bl) break block29;
                object2 = Files.readAllLines(file.toPath());
                object3 = Files.newBufferedWriter(file.toPath(), Charset.forName("Windows-1252"), new OpenOption[0]);
                object = null;
                try {
                    ((Writer)object3).write("{\\rtf1\\ansi\\ansicpg1252\\deff0\\deflang1033{\\fonttbl{\\f0\\fnil\\fcharset0 Arial;}}\n\\viewkind4\\uc1\\pard\\sa200\\sl276\\slmult1\\lang9\\fs20 ");
                    object2.forEach(arg_0 -> WinMsiBundler.lambda$ensureByMutationFileIsRTF$16((Writer)object3, arg_0));
                    ((Writer)object3).write("}\r\n");
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (object3 != null) {
                        if (object != null) {
                            try {
                                ((Writer)object3).close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            ((Writer)object3).close();
                        }
                    }
                }
            }
            catch (IOException iOException) {
                Log.verbose(iOException);
            }
        }
    }

    private static /* synthetic */ void lambda$ensureByMutationFileIsRTF$16(Writer writer, String string) {
        try {
            for (char c : string.toCharArray()) {
                if (c < '\u0010') {
                    writer.write("\\'0");
                    writer.write(Integer.toHexString(c));
                    continue;
                }
                if (c > '\u00ff') {
                    writer.write("\\ud");
                    writer.write(Integer.toString(c));
                    writer.write("?");
                    continue;
                }
                if (c < ' ' || c >= '\u0080' || c == '\\' || c == '{' || c == '}') {
                    writer.write("\\'");
                    writer.write(Integer.toHexString(c));
                    continue;
                }
                writer.write(c);
            }
            if (string.length() < 1) {
                writer.write("\\par");
            } else {
                writer.write(" ");
            }
            writer.write("\r\n");
        }
        catch (IOException iOException) {
            Log.verbose(iOException);
        }
    }

    static class VersionExtractor
    extends PrintStream {
        double version = 0.0;

        public VersionExtractor() {
            super(new ByteArrayOutputStream());
        }

        double getVersion() {
            if (this.version == 0.0) {
                String string = new String(((ByteArrayOutputStream)this.out).toByteArray());
                Pattern pattern = Pattern.compile("version (\\d+.\\d+)");
                Matcher matcher = pattern.matcher(string);
                if (matcher.find()) {
                    String string2 = matcher.group(1);
                    this.version = new Double(string2);
                }
            }
            return this.version;
        }
    }
}

