/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.jmx.json.impl;

import com.oracle.javafx.jmx.json.JSONException;
import com.oracle.javafx.jmx.json.impl.JSONMessages;
import com.oracle.javafx.jmx.json.impl.JSONSymbol;
import java.io.IOException;
import java.io.Reader;

final class JSONScanner {
    private Reader reader;
    private String value;
    private int prevChar;
    private int x;
    private int y = 1;
    private int checkpointX;
    private int checkpointY;
    private long offset;
    private boolean isInt;

    JSONScanner(Reader reader) throws IOException {
        this.reader = reader;
        this.offset = 0L;
        this.prevChar = reader.read();
    }

    JSONSymbol nextSymbol() throws JSONException, IOException {
        JSONSymbol jSONSymbol;
        int n = this.prevChar;
        while (n != -1 && (n == 32 || n == 9 || n == 12 || n == 10 || n == 13)) {
            n = this.readChar(true);
        }
        this.value = null;
        switch (n) {
            case -1: {
                jSONSymbol = JSONSymbol.EOS;
                this.prevChar = -1;
                break;
            }
            case 123: {
                jSONSymbol = JSONSymbol.CURLYOPEN;
                this.prevChar = this.readChar(true);
                break;
            }
            case 125: {
                jSONSymbol = JSONSymbol.CURLYCLOSE;
                this.prevChar = this.readChar(true);
                break;
            }
            case 91: {
                jSONSymbol = JSONSymbol.SQUAREOPEN;
                this.prevChar = this.readChar(true);
                break;
            }
            case 93: {
                jSONSymbol = JSONSymbol.SQUARECLOSE;
                this.prevChar = this.readChar(true);
                break;
            }
            case 58: {
                jSONSymbol = JSONSymbol.COLON;
                this.prevChar = this.readChar(true);
                break;
            }
            case 44: {
                jSONSymbol = JSONSymbol.COMMA;
                this.prevChar = this.readChar(true);
                break;
            }
            case 116: {
                this.readKeyword("true");
                jSONSymbol = JSONSymbol.KEYWORD;
                break;
            }
            case 102: {
                this.readKeyword("false");
                jSONSymbol = JSONSymbol.KEYWORD;
                break;
            }
            case 110: {
                this.readKeyword("null");
                jSONSymbol = JSONSymbol.KEYWORD;
                break;
            }
            case 34: {
                this.value = this.readString();
                jSONSymbol = JSONSymbol.STRING;
                break;
            }
            case 45: {
                this.value = this.readNumber(n);
                jSONSymbol = JSONSymbol.NUMBER;
                break;
            }
            default: {
                if (n >= 48 && n <= 57) {
                    this.value = this.readNumber(n);
                    jSONSymbol = JSONSymbol.NUMBER;
                    break;
                }
                Object[] objectArray = new Object[]{Character.valueOf((char)n)};
                throw new JSONException(JSONMessages.localize(objectArray, "unexpected_char"), this.line(), this.column());
            }
        }
        return jSONSymbol;
    }

    String getValue() {
        return this.value;
    }

    private void readKeyword(String string) throws JSONException, IOException {
        int n;
        int n2 = 0;
        for (n = 1; n < string.length() && (n2 = this.readChar(false)) == string.charAt(n); ++n) {
        }
        if (n < string.length()) {
            Object[] objectArray = new Object[]{Character.valueOf((char)n2)};
            throw new JSONException(JSONMessages.localize(objectArray, "unexpected_char"), this.line(), this.column());
        }
        this.value = string;
        this.prevChar = this.readChar(true);
    }

    private String readString() throws JSONException, IOException {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        do {
            n = this.readChar(false);
            block0 : switch (n) {
                case -1: {
                    throw new JSONException(JSONMessages.localize(null, "unexpected_end_of_stream"), this.line(), this.column());
                }
                case 92: {
                    int n2 = this.readChar(false);
                    switch (n2) {
                        case 34: 
                        case 47: 
                        case 92: {
                            stringBuilder.append((char)n2);
                            break block0;
                        }
                        case 98: {
                            stringBuilder.append('\b');
                            break block0;
                        }
                        case 102: {
                            stringBuilder.append('\f');
                            break block0;
                        }
                        case 110: {
                            stringBuilder.append('\n');
                            break block0;
                        }
                        case 114: {
                            stringBuilder.append('\r');
                            break block0;
                        }
                        case 116: {
                            stringBuilder.append('\t');
                            break block0;
                        }
                        case 117: {
                            int n3 = 0;
                            int n4 = 4;
                            while (--n4 >= 0) {
                                n2 = this.readChar(false);
                                n3 = (char)(n3 << 4);
                                if (n2 >= 48 && n2 <= 57) {
                                    n3 = (char)(n3 | (char)n2 - 48);
                                    continue;
                                }
                                if (n2 >= 97 && n2 <= 102) {
                                    n3 = (char)(n3 | (char)n2 - 97 + 10);
                                    continue;
                                }
                                if (n2 >= 65 && n2 <= 70) {
                                    n3 = (char)(n3 | (char)n2 - 65 + 10);
                                    continue;
                                }
                                Object[] objectArray = new Object[]{Character.valueOf((char)n2)};
                                throw new JSONException(JSONMessages.localize(objectArray, "unexpected_char"), this.line(), this.column());
                            }
                            stringBuilder.append((char)(n3 & 0xFFFF));
                            break block0;
                        }
                    }
                    Object[] objectArray = new Object[]{Character.valueOf((char)n2)};
                    throw new JSONException(JSONMessages.localize(objectArray, "unexpected_char"), this.line(), this.column());
                }
                case 34: {
                    break;
                }
                default: {
                    if (n >= 0 && n <= 31 || n >= 127 && n <= 159) {
                        throw new JSONException(JSONMessages.localize(null, "control_character_in_string"), this.line(), this.column());
                    }
                    stringBuilder.append((char)n);
                }
            }
        } while (n != 34);
        this.prevChar = this.readChar(true);
        return stringBuilder.toString();
    }

    private String readNumber(int n) throws JSONException, IOException {
        int n2;
        int n3 = n;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append((char)n3);
        if (n3 == 45) {
            n3 = this.readChar(true);
            stringBuilder.append((char)n3);
            if (n3 < 48 || n3 > 57) {
                Object[] objectArray = new Object[]{Character.valueOf((char)n3)};
                throw new JSONException(JSONMessages.localize(objectArray, "unexpected_char"), this.line(), this.column());
            }
        }
        this.isInt = true;
        if (n3 == 48) {
            n3 = this.readChar(true);
            stringBuilder.append((char)n3);
        } else {
            do {
                n3 = this.readChar(true);
                stringBuilder.append((char)n3);
            } while (n3 >= 48 && n3 <= 57);
        }
        if (n3 == 46) {
            this.isInt = false;
            n2 = 0;
            do {
                n3 = this.readChar(true);
                stringBuilder.append((char)n3);
                ++n2;
            } while (n3 >= 48 && n3 <= 57);
            if (n2 == 1) {
                Object[] objectArray = new Object[]{Character.valueOf((char)n3)};
                throw new JSONException(JSONMessages.localize(objectArray, "unexpected_char"), this.line(), this.column());
            }
        }
        if (n3 == 101 || n3 == 69) {
            this.isInt = false;
            n3 = this.readChar(false);
            stringBuilder.append((char)n3);
            if (n3 == 43 || n3 == 45) {
                n3 = this.readChar(false);
                stringBuilder.append((char)n3);
            }
            n2 = 0;
            while (n3 >= 48 && n3 <= 57) {
                n3 = this.readChar(true);
                stringBuilder.append((char)n3);
                ++n2;
            }
            if (n2 == 0) {
                Object[] objectArray = new Object[]{Character.valueOf((char)n3)};
                throw new JSONException(JSONMessages.localize(objectArray, "unexpected_char"), this.line(), this.column());
            }
        }
        this.prevChar = n3;
        return stringBuilder.toString().substring(0, stringBuilder.length() - 1);
    }

    private int readChar(boolean bl) throws IOException {
        int n = this.reader.read();
        if (bl) {
            this.checkpointX = this.x;
            this.checkpointY = this.y;
        }
        if (n == 10) {
            ++this.y;
            this.x = 0;
        } else {
            ++this.x;
        }
        ++this.offset;
        return n;
    }

    boolean isInteger() {
        return this.isInt;
    }

    void close() throws IOException {
        this.reader.close();
    }

    int line() {
        return this.y;
    }

    int column() {
        return this.x;
    }

    long getCharacterOffset() {
        return this.offset;
    }

    public String toString() {
        return this.y + ":" + this.x + (this.offset >= 0L ? "@" + this.offset : "");
    }
}

