/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.panel;

import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.security.CertStore;
import com.sun.deploy.security.DeployClientAuthCertStore;
import com.sun.deploy.security.DeploySSLCertStore;
import com.sun.deploy.security.DeploySigningCertStore;
import com.sun.deploy.security.RootCertStore;
import com.sun.deploy.security.SSLRootCertStore;
import com.sun.deploy.trace.Trace;
import java.security.Key;
import java.security.cert.Certificate;
import java.util.Collection;
import java.util.LinkedHashMap;
import javax.swing.JDialog;

class CertificatesInfo {
    private LinkedHashMap activeTrustedCertsMap = new LinkedHashMap();
    private LinkedHashMap activeHttpsCertsMap = new LinkedHashMap();
    private LinkedHashMap activeRootCACertsMap = new LinkedHashMap();
    private LinkedHashMap activeHttpsRootCACertsMap = new LinkedHashMap();
    private LinkedHashMap activeClientAuthCertsMap = new LinkedHashMap();
    private LinkedHashMap activeSysTrustedCertsMap = new LinkedHashMap();
    private LinkedHashMap activeSysHttpsCertsMap = new LinkedHashMap();
    private LinkedHashMap activeSysRootCACertsMap = new LinkedHashMap();
    private LinkedHashMap activeSysHttpsRootCACertsMap = new LinkedHashMap();
    private LinkedHashMap activeSysClientAuthCertsMap = new LinkedHashMap();

    public CertificatesInfo() {
        this.reset();
    }

    public Collection getTrustedCertificates(int n) {
        if (n == 0) {
            return this.activeTrustedCertsMap.keySet();
        }
        return this.activeSysTrustedCertsMap.keySet();
    }

    public Collection getHttpsCertificates(int n) {
        if (n == 0) {
            return this.activeHttpsCertsMap.keySet();
        }
        return this.activeSysHttpsCertsMap.keySet();
    }

    public Collection getRootCACertificates(int n) {
        if (n == 0) {
            return this.activeRootCACertsMap.keySet();
        }
        return this.activeSysRootCACertsMap.keySet();
    }

    public Collection getHttpsRootCACertificates(int n) {
        if (n == 0) {
            return this.activeHttpsRootCACertsMap.keySet();
        }
        return this.activeSysHttpsRootCACertsMap.keySet();
    }

    public Collection getClientAuthCertificates(int n) {
        if (n == 0) {
            return this.activeClientAuthCertsMap.keySet();
        }
        return this.activeSysClientAuthCertsMap.keySet();
    }

    public void removeTrustedCertificate(Certificate certificate) {
        CertStore certStore = DeploySigningCertStore.getUserCertStore();
        try {
            certStore.load(true);
            if (certStore.remove(certificate)) {
                certStore.save();
                Object v = this.activeTrustedCertsMap.remove(certificate);
            }
        }
        catch (Exception exception) {
            Trace.printException(exception);
        }
    }

    public void removeHttpsCertificate(Certificate certificate) {
        CertStore certStore = DeploySSLCertStore.getUserCertStore();
        try {
            certStore.load(true);
            if (certStore.remove(certificate)) {
                certStore.save();
                Object v = this.activeHttpsCertsMap.remove(certificate);
            }
        }
        catch (Exception exception) {
            Trace.printException(exception);
        }
    }

    public void removeRootCACertificate(Certificate certificate) {
        CertStore certStore = RootCertStore.getUserCertStore();
        try {
            certStore.load(true);
            if (certStore.remove(certificate)) {
                certStore.save();
                Object v = this.activeRootCACertsMap.remove(certificate);
            }
        }
        catch (Exception exception) {
            Trace.printException(exception);
        }
    }

    public void removeHttpsRootCACertificate(Certificate certificate) {
        CertStore certStore = SSLRootCertStore.getUserCertStore();
        try {
            certStore.load(true);
            if (certStore.remove(certificate)) {
                certStore.save();
                Object v = this.activeHttpsRootCACertsMap.remove(certificate);
            }
        }
        catch (Exception exception) {
            Trace.printException(exception);
        }
    }

    public void removeClientAuthCertificate(JDialog jDialog, Certificate[][] certificateArray) {
        DeployClientAuthCertStore deployClientAuthCertStore = DeployClientAuthCertStore.getUserCertStore(jDialog);
        Certificate[] certificateArray2 = new Certificate[certificateArray.length];
        try {
            int n;
            deployClientAuthCertStore.load(true);
            for (n = 0; n < certificateArray.length; ++n) {
                certificateArray2[n] = certificateArray[n][0];
            }
            n = deployClientAuthCertStore.remove(certificateArray2) ? 1 : 0;
            if (n != 0) {
                deployClientAuthCertStore.save();
                for (int i = 0; i < certificateArray.length; ++i) {
                    this.activeClientAuthCertsMap.remove(certificateArray[i]);
                }
            }
        }
        catch (Exception exception) {
            Trace.printException(jDialog, exception);
        }
    }

    public void addTrustedCertificate(Certificate certificate) {
        CertStore certStore = DeploySigningCertStore.getUserCertStore();
        try {
            certStore.load(true);
            if (certStore.add(certificate)) {
                certStore.save();
                this.activeTrustedCertsMap.put(certificate, certificate);
            }
        }
        catch (Exception exception) {
            Trace.printException(exception);
        }
    }

    public void addHttpsCertificate(Certificate certificate) {
        CertStore certStore = DeploySSLCertStore.getUserCertStore();
        try {
            certStore.load(true);
            if (certStore.add(certificate)) {
                certStore.save();
                this.activeHttpsCertsMap.put(certificate, certificate);
            }
        }
        catch (Exception exception) {
            Trace.printException(exception);
        }
    }

    public void addCACertificate(Certificate certificate) {
        CertStore certStore = RootCertStore.getUserCertStore();
        try {
            certStore.load(true);
            if (certStore.add(certificate)) {
                certStore.save();
                this.activeRootCACertsMap.put(certificate, certificate);
            }
        }
        catch (Exception exception) {
            Trace.printException(exception);
        }
    }

    public void addHttpsCACertificate(Certificate certificate) {
        CertStore certStore = SSLRootCertStore.getUserCertStore();
        try {
            certStore.load(true);
            if (certStore.add(certificate)) {
                certStore.save();
                this.activeHttpsRootCACertsMap.put(certificate, certificate);
            }
        }
        catch (Exception exception) {
            Trace.printException(exception);
        }
    }

    public void addClientAuthCertChain(JDialog jDialog, Certificate[] certificateArray, Key key) {
        DeployClientAuthCertStore deployClientAuthCertStore = DeployClientAuthCertStore.getUserCertStore(jDialog);
        try {
            deployClientAuthCertStore.load(true);
            boolean bl = deployClientAuthCertStore.addCertKey(certificateArray, key);
            if (bl) {
                deployClientAuthCertStore.save();
                this.activeClientAuthCertsMap.put(certificateArray, certificateArray);
            }
        }
        catch (Exception exception) {
            Trace.printException(exception);
        }
    }

    public void reset() {
        Object object9;
        Object object22;
        Object object32;
        Object object42;
        Object object52;
        Object object62;
        Object object72;
        Object object82;
        this.activeTrustedCertsMap.clear();
        this.activeHttpsCertsMap.clear();
        this.activeRootCACertsMap.clear();
        this.activeHttpsRootCACertsMap.clear();
        this.activeClientAuthCertsMap.clear();
        this.activeSysTrustedCertsMap.clear();
        this.activeSysHttpsCertsMap.clear();
        this.activeSysRootCACertsMap.clear();
        this.activeSysHttpsRootCACertsMap.clear();
        this.activeSysClientAuthCertsMap.clear();
        CertStore certStore = DeploySigningCertStore.getUserCertStore();
        try {
            certStore.load();
            for (Object object82 : certStore.getCertificates()) {
                this.activeTrustedCertsMap.put(object82, object82);
            }
        }
        catch (Exception exception) {
            Trace.printException(exception);
        }
        CertStore certStore2 = DeploySigningCertStore.getSystemCertStore();
        try {
            certStore2.load();
            for (Object object72 : certStore2.getCertificates()) {
                this.activeSysTrustedCertsMap.put(object72, object72);
            }
        }
        catch (Exception exception) {
            Trace.printException(exception);
        }
        object82 = DeploySSLCertStore.getUserCertStore();
        try {
            object82.load();
            for (Object object62 : object82.getCertificates()) {
                this.activeHttpsCertsMap.put(object62, object62);
            }
        }
        catch (Exception exception) {
            Trace.printException(exception);
        }
        object72 = DeploySSLCertStore.getSystemCertStore();
        try {
            object72.load();
            for (Object object52 : object72.getCertificates()) {
                this.activeSysHttpsCertsMap.put(object52, object52);
            }
        }
        catch (Exception exception) {
            Trace.printException(exception);
        }
        object62 = RootCertStore.getUserCertStore();
        try {
            object62.load();
            for (Object object42 : object62.getCertificates()) {
                this.activeRootCACertsMap.put(object42, object42);
            }
        }
        catch (Exception exception) {
            Trace.printException(exception);
        }
        object52 = RootCertStore.getSystemCertStore();
        try {
            object52.load();
            for (Object object32 : object52.getCertificates()) {
                this.activeSysRootCACertsMap.put(object32, object32);
            }
        }
        catch (Exception exception) {
            Trace.printException(exception);
        }
        object42 = SSLRootCertStore.getUserCertStore();
        try {
            object42.load();
            for (Object object22 : object42.getCertificates()) {
                this.activeHttpsRootCACertsMap.put(object22, object22);
            }
        }
        catch (Exception exception) {
            Trace.printException(exception);
        }
        object32 = SSLRootCertStore.getSystemCertStore();
        try {
            object32.load();
            for (Object object9 : object32.getCertificates()) {
                this.activeSysHttpsRootCACertsMap.put(object9, object9);
            }
        }
        catch (Exception exception) {
            Trace.printException(exception);
        }
        object22 = DeployClientAuthCertStore.getUserCertStore(null);
        try {
            object22.load();
            for (Object object10 : object22.getCertificates()) {
                this.activeClientAuthCertsMap.put(object10, object10);
            }
        }
        catch (Exception exception) {
            Trace.printException(exception);
        }
        object9 = DeployClientAuthCertStore.getSystemCertStore(null);
        try {
            object9.load();
            for (Certificate[] certificateArray : object9.getCertificates()) {
                this.activeSysClientAuthCertsMap.put(certificateArray, certificateArray);
            }
        }
        catch (Exception exception) {
            Trace.printException(exception);
        }
    }

    private static String getMessage(String string) {
        return ResourceManager.getMessage(string);
    }
}

