/*
 * Decompiled with CFR 0.152.
 */
package sun.security.jgss.wrapper;

import com.sun.security.jgss.InquireType;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Provider;
import javax.security.auth.kerberos.DelegationPermission;
import org.ietf.jgss.ChannelBinding;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.MessageProp;
import org.ietf.jgss.Oid;
import sun.security.jgss.GSSExceptionImpl;
import sun.security.jgss.GSSHeader;
import sun.security.jgss.GSSUtil;
import sun.security.jgss.spi.GSSContextSpi;
import sun.security.jgss.spi.GSSCredentialSpi;
import sun.security.jgss.spi.GSSNameSpi;
import sun.security.jgss.spnego.NegTokenInit;
import sun.security.jgss.spnego.NegTokenTarg;
import sun.security.jgss.wrapper.GSSCredElement;
import sun.security.jgss.wrapper.GSSLibStub;
import sun.security.jgss.wrapper.GSSNameElement;
import sun.security.jgss.wrapper.Krb5Util;
import sun.security.jgss.wrapper.SunNativeProvider;
import sun.security.util.DerValue;
import sun.security.util.ObjectIdentifier;

class NativeGSSContext
implements GSSContextSpi {
    private static final int GSS_C_DELEG_FLAG = 1;
    private static final int GSS_C_MUTUAL_FLAG = 2;
    private static final int GSS_C_REPLAY_FLAG = 4;
    private static final int GSS_C_SEQUENCE_FLAG = 8;
    private static final int GSS_C_CONF_FLAG = 16;
    private static final int GSS_C_INTEG_FLAG = 32;
    private static final int GSS_C_ANON_FLAG = 64;
    private static final int GSS_C_PROT_READY_FLAG = 128;
    private static final int GSS_C_TRANS_FLAG = 256;
    private static final int NUM_OF_INQUIRE_VALUES = 6;
    private long pContext = 0L;
    private GSSNameElement srcName;
    private GSSNameElement targetName;
    private GSSCredElement cred;
    private boolean isInitiator;
    private boolean isEstablished;
    private Oid actualMech;
    private ChannelBinding cb;
    private GSSCredElement delegatedCred;
    private int flags;
    private int lifetime = 0;
    private final GSSLibStub cStub;
    private boolean skipDelegPermCheck;
    private boolean skipServicePermCheck;

    private static Oid getMechFromSpNegoToken(byte[] byArray, boolean bl) throws GSSException {
        Oid oid = null;
        if (bl) {
            GSSHeader gSSHeader = null;
            try {
                gSSHeader = new GSSHeader(new ByteArrayInputStream(byArray));
            }
            catch (IOException iOException) {
                throw new GSSExceptionImpl(11, iOException);
            }
            int n = gSSHeader.getMechTokenLength();
            byte[] byArray2 = new byte[n];
            System.arraycopy(byArray, byArray.length - n, byArray2, 0, byArray2.length);
            NegTokenInit negTokenInit = new NegTokenInit(byArray2);
            if (negTokenInit.getMechToken() != null) {
                Oid[] oidArray = negTokenInit.getMechTypeList();
                oid = oidArray[0];
            }
        } else {
            NegTokenTarg negTokenTarg = new NegTokenTarg(byArray);
            oid = negTokenTarg.getSupportedMech();
        }
        return oid;
    }

    private void doServicePermCheck() throws GSSException {
        if (System.getSecurityManager() != null) {
            Object object;
            String string;
            String string2 = string = this.isInitiator ? "initiate" : "accept";
            if (GSSUtil.isSpNegoMech(this.cStub.getMech()) && this.isInitiator && !this.isEstablished) {
                if (this.srcName == null) {
                    object = new GSSCredElement(null, this.lifetime, 1, GSSLibStub.getInstance(GSSUtil.GSS_KRB5_MECH_OID));
                    ((GSSCredElement)object).dispose();
                } else {
                    object = Krb5Util.getTGSName(this.srcName);
                    Krb5Util.checkServicePermission((String)object, string);
                }
            }
            object = this.targetName.getKrbName();
            Krb5Util.checkServicePermission((String)object, string);
            this.skipServicePermCheck = true;
        }
    }

    private void doDelegPermCheck() throws GSSException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            String string = this.targetName.getKrbName();
            String string2 = Krb5Util.getTGSName(this.targetName);
            StringBuffer stringBuffer = new StringBuffer("\"");
            stringBuffer.append(string).append("\" \"");
            stringBuffer.append(string2).append('\"');
            String string3 = stringBuffer.toString();
            SunNativeProvider.debug("Checking DelegationPermission (" + string3 + ")");
            DelegationPermission delegationPermission = new DelegationPermission(string3);
            securityManager.checkPermission(delegationPermission);
            this.skipDelegPermCheck = true;
        }
    }

    private byte[] retrieveToken(InputStream inputStream, int n) throws GSSException {
        try {
            byte[] byArray = null;
            if (n != -1) {
                SunNativeProvider.debug("Precomputed mechToken length: " + n);
                GSSHeader gSSHeader = new GSSHeader(ObjectIdentifier.of(this.cStub.getMech().toString()), n);
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(600);
                byte[] byArray2 = new byte[n];
                int n2 = inputStream.read(byArray2);
                assert (n == n2);
                gSSHeader.encode(byteArrayOutputStream);
                byteArrayOutputStream.write(byArray2);
                byArray = byteArrayOutputStream.toByteArray();
            } else {
                assert (n == -1);
                DerValue derValue = new DerValue(inputStream);
                byArray = derValue.toByteArray();
            }
            SunNativeProvider.debug("Complete Token length: " + byArray.length);
            return byArray;
        }
        catch (IOException iOException) {
            throw new GSSExceptionImpl(11, iOException);
        }
    }

    NativeGSSContext(GSSNameElement gSSNameElement, GSSCredElement gSSCredElement, int n, GSSLibStub gSSLibStub) throws GSSException {
        if (gSSNameElement == null) {
            throw new GSSException(11, 1, "null peer");
        }
        this.cStub = gSSLibStub;
        this.cred = gSSCredElement;
        this.targetName = gSSNameElement;
        this.isInitiator = true;
        this.lifetime = n;
        if (GSSUtil.isKerberosMech(this.cStub.getMech())) {
            this.doServicePermCheck();
            if (this.cred == null) {
                this.cred = new GSSCredElement(null, this.lifetime, 1, this.cStub);
            }
            this.srcName = this.cred.getName();
        }
    }

    NativeGSSContext(GSSCredElement gSSCredElement, GSSLibStub gSSLibStub) throws GSSException {
        this.cStub = gSSLibStub;
        this.cred = gSSCredElement;
        if (this.cred != null) {
            this.targetName = this.cred.getName();
        }
        this.isInitiator = false;
        if (GSSUtil.isKerberosMech(this.cStub.getMech()) && this.targetName != null) {
            this.doServicePermCheck();
        }
    }

    NativeGSSContext(long l, GSSLibStub gSSLibStub) throws GSSException {
        assert (this.pContext != 0L);
        this.pContext = l;
        this.cStub = gSSLibStub;
        long[] lArray = this.cStub.inquireContext(this.pContext);
        if (lArray.length != 6) {
            throw new RuntimeException("Bug w/ GSSLibStub.inquireContext()");
        }
        this.srcName = new GSSNameElement(lArray[0], this.cStub);
        this.targetName = new GSSNameElement(lArray[1], this.cStub);
        this.isInitiator = lArray[2] != 0L;
        this.isEstablished = lArray[3] != 0L;
        this.flags = (int)lArray[4];
        this.lifetime = (int)lArray[5];
        Oid oid = this.cStub.getMech();
        if (GSSUtil.isSpNegoMech(oid) || GSSUtil.isKerberosMech(oid)) {
            this.doServicePermCheck();
        }
    }

    @Override
    public Provider getProvider() {
        return SunNativeProvider.INSTANCE;
    }

    @Override
    public byte[] initSecContext(InputStream inputStream, int n) throws GSSException {
        byte[] byArray = null;
        if (!this.isEstablished && this.isInitiator) {
            byte[] byArray2 = null;
            if (this.pContext != 0L) {
                byArray2 = this.retrieveToken(inputStream, n);
                SunNativeProvider.debug("initSecContext=> inToken len=" + byArray2.length);
            }
            if (!this.getCredDelegState()) {
                this.skipDelegPermCheck = true;
            }
            if (GSSUtil.isKerberosMech(this.cStub.getMech()) && !this.skipDelegPermCheck) {
                this.doDelegPermCheck();
            }
            long l = this.cred == null ? 0L : this.cred.pCred;
            byArray = this.cStub.initContext(l, this.targetName.pName, this.cb, byArray2, this);
            SunNativeProvider.debug("initSecContext=> outToken len=" + (byArray == null ? 0 : byArray.length));
            if (GSSUtil.isSpNegoMech(this.cStub.getMech()) && byArray != null) {
                this.actualMech = NativeGSSContext.getMechFromSpNegoToken(byArray, true);
                if (GSSUtil.isKerberosMech(this.actualMech)) {
                    if (!this.skipServicePermCheck) {
                        this.doServicePermCheck();
                    }
                    if (!this.skipDelegPermCheck) {
                        this.doDelegPermCheck();
                    }
                }
            }
            if (this.isEstablished) {
                if (this.srcName == null) {
                    this.srcName = new GSSNameElement(this.cStub.getContextName(this.pContext, true), this.cStub);
                }
                if (this.cred == null) {
                    this.cred = new GSSCredElement(this.srcName, this.lifetime, 1, this.cStub);
                }
            }
        }
        return byArray;
    }

    @Override
    public byte[] acceptSecContext(InputStream inputStream, int n) throws GSSException {
        byte[] byArray = null;
        if (!this.isEstablished && !this.isInitiator) {
            byte[] byArray2 = this.retrieveToken(inputStream, n);
            SunNativeProvider.debug("acceptSecContext=> inToken len=" + byArray2.length);
            long l = this.cred == null ? 0L : this.cred.pCred;
            byArray = this.cStub.acceptContext(l, this.cb, byArray2, this);
            SunNativeProvider.debug("acceptSecContext=> outToken len=" + (byArray == null ? 0 : byArray.length));
            if (this.targetName == null) {
                this.targetName = new GSSNameElement(this.cStub.getContextName(this.pContext, false), this.cStub);
                if (this.cred != null) {
                    this.cred.dispose();
                }
                this.cred = new GSSCredElement(this.targetName, this.lifetime, 2, this.cStub);
            }
            if (GSSUtil.isSpNegoMech(this.cStub.getMech()) && byArray != null && !this.skipServicePermCheck && GSSUtil.isKerberosMech(NativeGSSContext.getMechFromSpNegoToken(byArray, false))) {
                this.doServicePermCheck();
            }
        }
        return byArray;
    }

    @Override
    public boolean isEstablished() {
        return this.isEstablished;
    }

    @Override
    public void dispose() throws GSSException {
        this.srcName = null;
        this.targetName = null;
        this.cred = null;
        this.delegatedCred = null;
        if (this.pContext != 0L) {
            this.pContext = this.cStub.deleteContext(this.pContext);
            this.pContext = 0L;
        }
    }

    @Override
    public int getWrapSizeLimit(int n, boolean bl, int n2) throws GSSException {
        return this.cStub.wrapSizeLimit(this.pContext, bl ? 1 : 0, n, n2);
    }

    @Override
    public byte[] wrap(byte[] byArray, int n, int n2, MessageProp messageProp) throws GSSException {
        byte[] byArray2 = byArray;
        if (n != 0 || n2 != byArray.length) {
            byArray2 = new byte[n2];
            System.arraycopy(byArray, n, byArray2, 0, n2);
        }
        return this.cStub.wrap(this.pContext, byArray2, messageProp);
    }

    public void wrap(byte[] byArray, int n, int n2, OutputStream outputStream, MessageProp messageProp) throws GSSException {
        try {
            byte[] byArray2 = this.wrap(byArray, n, n2, messageProp);
            outputStream.write(byArray2);
        }
        catch (IOException iOException) {
            throw new GSSExceptionImpl(11, iOException);
        }
    }

    public int wrap(byte[] byArray, int n, int n2, byte[] byArray2, int n3, MessageProp messageProp) throws GSSException {
        byte[] byArray3 = this.wrap(byArray, n, n2, messageProp);
        System.arraycopy(byArray3, 0, byArray2, n3, byArray3.length);
        return byArray3.length;
    }

    @Override
    public void wrap(InputStream inputStream, OutputStream outputStream, MessageProp messageProp) throws GSSException {
        try {
            byte[] byArray = new byte[inputStream.available()];
            int n = inputStream.read(byArray);
            byte[] byArray2 = this.wrap(byArray, 0, n, messageProp);
            outputStream.write(byArray2);
        }
        catch (IOException iOException) {
            throw new GSSExceptionImpl(11, iOException);
        }
    }

    @Override
    public byte[] unwrap(byte[] byArray, int n, int n2, MessageProp messageProp) throws GSSException {
        if (n != 0 || n2 != byArray.length) {
            byte[] byArray2 = new byte[n2];
            System.arraycopy(byArray, n, byArray2, 0, n2);
            return this.cStub.unwrap(this.pContext, byArray2, messageProp);
        }
        return this.cStub.unwrap(this.pContext, byArray, messageProp);
    }

    public int unwrap(byte[] byArray, int n, int n2, byte[] byArray2, int n3, MessageProp messageProp) throws GSSException {
        byte[] byArray3 = null;
        if (n != 0 || n2 != byArray.length) {
            byte[] byArray4 = new byte[n2];
            System.arraycopy(byArray, n, byArray4, 0, n2);
            byArray3 = this.cStub.unwrap(this.pContext, byArray4, messageProp);
        } else {
            byArray3 = this.cStub.unwrap(this.pContext, byArray, messageProp);
        }
        System.arraycopy(byArray3, 0, byArray2, n3, byArray3.length);
        return byArray3.length;
    }

    @Override
    public void unwrap(InputStream inputStream, OutputStream outputStream, MessageProp messageProp) throws GSSException {
        try {
            byte[] byArray = new byte[inputStream.available()];
            int n = inputStream.read(byArray);
            byte[] byArray2 = this.unwrap(byArray, 0, n, messageProp);
            outputStream.write(byArray2);
            outputStream.flush();
        }
        catch (IOException iOException) {
            throw new GSSExceptionImpl(11, iOException);
        }
    }

    public int unwrap(InputStream inputStream, byte[] byArray, int n, MessageProp messageProp) throws GSSException {
        byte[] byArray2;
        byte[] byArray3 = null;
        int n2 = 0;
        try {
            byArray3 = new byte[inputStream.available()];
            n2 = inputStream.read(byArray3);
            byArray2 = this.unwrap(byArray3, 0, n2, messageProp);
        }
        catch (IOException iOException) {
            throw new GSSExceptionImpl(11, iOException);
        }
        byArray2 = this.unwrap(byArray3, 0, n2, messageProp);
        System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
        return byArray2.length;
    }

    @Override
    public byte[] getMIC(byte[] byArray, int n, int n2, MessageProp messageProp) throws GSSException {
        int n3 = messageProp == null ? 0 : messageProp.getQOP();
        byte[] byArray2 = byArray;
        if (n != 0 || n2 != byArray.length) {
            byArray2 = new byte[n2];
            System.arraycopy(byArray, n, byArray2, 0, n2);
        }
        return this.cStub.getMic(this.pContext, n3, byArray2);
    }

    @Override
    public void getMIC(InputStream inputStream, OutputStream outputStream, MessageProp messageProp) throws GSSException {
        try {
            int n = 0;
            byte[] byArray = new byte[inputStream.available()];
            n = inputStream.read(byArray);
            byte[] byArray2 = this.getMIC(byArray, 0, n, messageProp);
            if (byArray2 != null && byArray2.length != 0) {
                outputStream.write(byArray2);
            }
        }
        catch (IOException iOException) {
            throw new GSSExceptionImpl(11, iOException);
        }
    }

    @Override
    public void verifyMIC(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4, MessageProp messageProp) throws GSSException {
        byte[] byArray3 = byArray;
        byte[] byArray4 = byArray2;
        if (n != 0 || n2 != byArray.length) {
            byArray3 = new byte[n2];
            System.arraycopy(byArray, n, byArray3, 0, n2);
        }
        if (n3 != 0 || n4 != byArray2.length) {
            byArray4 = new byte[n4];
            System.arraycopy(byArray2, n3, byArray4, 0, n4);
        }
        this.cStub.verifyMic(this.pContext, byArray3, byArray4, messageProp);
    }

    @Override
    public void verifyMIC(InputStream inputStream, InputStream inputStream2, MessageProp messageProp) throws GSSException {
        try {
            byte[] byArray = new byte[inputStream2.available()];
            int n = inputStream2.read(byArray);
            byte[] byArray2 = new byte[inputStream.available()];
            int n2 = inputStream.read(byArray2);
            this.verifyMIC(byArray2, 0, n2, byArray, 0, n, messageProp);
        }
        catch (IOException iOException) {
            throw new GSSExceptionImpl(11, iOException);
        }
    }

    @Override
    public byte[] export() throws GSSException {
        byte[] byArray = this.cStub.exportContext(this.pContext);
        this.pContext = 0L;
        return byArray;
    }

    private void changeFlags(int n, boolean bl) {
        if (this.isInitiator && this.pContext == 0L) {
            this.flags = bl ? (this.flags |= n) : (this.flags &= ~n);
        }
    }

    @Override
    public void requestMutualAuth(boolean bl) throws GSSException {
        this.changeFlags(2, bl);
    }

    @Override
    public void requestReplayDet(boolean bl) throws GSSException {
        this.changeFlags(4, bl);
    }

    @Override
    public void requestSequenceDet(boolean bl) throws GSSException {
        this.changeFlags(8, bl);
    }

    @Override
    public void requestCredDeleg(boolean bl) throws GSSException {
        this.changeFlags(1, bl);
    }

    @Override
    public void requestAnonymity(boolean bl) throws GSSException {
        this.changeFlags(64, bl);
    }

    @Override
    public void requestConf(boolean bl) throws GSSException {
        this.changeFlags(16, bl);
    }

    @Override
    public void requestInteg(boolean bl) throws GSSException {
        this.changeFlags(32, bl);
    }

    @Override
    public void requestDelegPolicy(boolean bl) throws GSSException {
    }

    @Override
    public void requestLifetime(int n) throws GSSException {
        if (this.isInitiator && this.pContext == 0L) {
            this.lifetime = n;
        }
    }

    @Override
    public void setChannelBinding(ChannelBinding channelBinding) throws GSSException {
        if (this.pContext == 0L) {
            this.cb = channelBinding;
        }
    }

    private boolean checkFlags(int n) {
        return (this.flags & n) != 0;
    }

    @Override
    public boolean getCredDelegState() {
        return this.checkFlags(1);
    }

    @Override
    public boolean getMutualAuthState() {
        return this.checkFlags(2);
    }

    @Override
    public boolean getReplayDetState() {
        return this.checkFlags(4);
    }

    @Override
    public boolean getSequenceDetState() {
        return this.checkFlags(8);
    }

    @Override
    public boolean getAnonymityState() {
        return this.checkFlags(64);
    }

    @Override
    public boolean isTransferable() throws GSSException {
        return this.checkFlags(256);
    }

    @Override
    public boolean isProtReady() {
        return this.checkFlags(128);
    }

    @Override
    public boolean getConfState() {
        return this.checkFlags(16);
    }

    @Override
    public boolean getIntegState() {
        return this.checkFlags(32);
    }

    @Override
    public boolean getDelegPolicyState() {
        return false;
    }

    @Override
    public int getLifetime() {
        return this.cStub.getContextTime(this.pContext);
    }

    @Override
    public GSSNameSpi getSrcName() throws GSSException {
        return this.srcName;
    }

    @Override
    public GSSNameSpi getTargName() throws GSSException {
        return this.targetName;
    }

    @Override
    public Oid getMech() throws GSSException {
        if (this.isEstablished && this.actualMech != null) {
            return this.actualMech;
        }
        return this.cStub.getMech();
    }

    @Override
    public GSSCredentialSpi getDelegCred() throws GSSException {
        return this.delegatedCred;
    }

    @Override
    public boolean isInitiator() {
        return this.isInitiator;
    }

    protected void finalize() throws Throwable {
        this.dispose();
    }

    @Override
    public Object inquireSecContext(InquireType inquireType) throws GSSException {
        throw new GSSException(16, -1, "Inquire type not supported.");
    }
}

