/*
 * Decompiled with CFR 0.152.
 */
package sun.security.jca;

import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import jdk.internal.event.EventHelper;
import sun.security.util.KeyUtil;

public final class JCAUtil {
    private static final int ARRAY_SIZE = 4096;
    private static volatile SecureRandom def = null;

    private JCAUtil() {
    }

    public static int getTempArraySize(int n) {
        return Math.min(4096, n);
    }

    public static SecureRandom getSecureRandom() {
        return CachedSecureRandomHolder.instance;
    }

    static void clearDefSecureRandom() {
        def = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SecureRandom getDefSecureRandom() {
        SecureRandom secureRandom = def;
        if (secureRandom != null) return secureRandom;
        Class<JCAUtil> clazz = JCAUtil.class;
        synchronized (JCAUtil.class) {
            secureRandom = def;
            if (secureRandom != null) return secureRandom;
            def = secureRandom = new SecureRandom();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return secureRandom;
        }
    }

    public static void tryCommitCertEvent(Certificate certificate) {
        if (EventHelper.isLoggingSecurity() && certificate instanceof X509Certificate) {
            X509Certificate x509Certificate = (X509Certificate)certificate;
            PublicKey publicKey = x509Certificate.getPublicKey();
            String string = x509Certificate.getSigAlgName();
            String string2 = x509Certificate.getSerialNumber().toString(16);
            String string3 = x509Certificate.getSubjectX500Principal().toString();
            String string4 = x509Certificate.getIssuerX500Principal().toString();
            String string5 = publicKey.getAlgorithm();
            int n = KeyUtil.getKeySize(publicKey);
            int n2 = x509Certificate.hashCode();
            long l = x509Certificate.getNotBefore().getTime();
            long l2 = x509Certificate.getNotAfter().getTime();
            EventHelper.logX509CertificateEvent(string, string2, string3, string4, string5, n, n2, l, l2);
        }
    }

    private static class CachedSecureRandomHolder {
        public static SecureRandom instance = new SecureRandom();

        private CachedSecureRandomHolder() {
        }
    }
}

