/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.marlin;

import sun.java2d.marlin.ArrayCacheConst;
import sun.java2d.marlin.FloatMath;
import sun.java2d.marlin.IRendererContext;
import sun.java2d.marlin.IntArrayCache;
import sun.java2d.marlin.MarlinConst;
import sun.java2d.marlin.MarlinProperties;
import sun.java2d.marlin.MarlinUtils;
import sun.java2d.marlin.OffHeapArray;
import sun.java2d.marlin.RendererStats;
import sun.misc.Unsafe;

public final class MarlinCache
implements MarlinConst {
    static final boolean FORCE_RLE = MarlinProperties.isForceRLE();
    static final boolean FORCE_NO_RLE = MarlinProperties.isForceNoRLE();
    static final int RLE_MIN_WIDTH = Math.max(BLOCK_SIZE, MarlinProperties.getRLEMinWidth());
    static final int RLE_MAX_WIDTH = 0x800000;
    static final long INITIAL_CHUNK_ARRAY = TILE_H * INITIAL_PIXEL_WIDTH >> 2;
    static final byte[] ALPHA_MAP;
    static final OffHeapArray ALPHA_MAP_UNSAFE;
    int bboxX0;
    int bboxY0;
    int bboxX1;
    int bboxY1;
    final long[] rowAAChunkIndex = new long[TILE_H];
    final int[] rowAAx0 = new int[TILE_H];
    final int[] rowAAx1 = new int[TILE_H];
    final int[] rowAAEnc = new int[TILE_H];
    final long[] rowAALen = new long[TILE_H];
    final long[] rowAAPos = new long[TILE_H];
    final OffHeapArray rowAAChunk;
    long rowAAChunkPos;
    int[] touchedTile;
    final RendererStats rdrStats;
    private final IntArrayCache.Reference touchedTile_ref;
    int tileMin;
    int tileMax;
    boolean useRLE = false;

    MarlinCache(IRendererContext iRendererContext) {
        this.rdrStats = iRendererContext.stats();
        this.rowAAChunk = iRendererContext.newOffHeapArray(INITIAL_CHUNK_ARRAY);
        this.touchedTile_ref = iRendererContext.newCleanIntArrayRef(256);
        this.touchedTile = this.touchedTile_ref.initial;
        this.tileMin = Integer.MAX_VALUE;
        this.tileMax = Integer.MIN_VALUE;
    }

    void init(int n, int n2, int n3, int n4) {
        this.bboxX0 = n;
        this.bboxY0 = n2;
        this.bboxX1 = n3;
        this.bboxY1 = n4;
        int n5 = n3 - n;
        this.useRLE = FORCE_NO_RLE ? false : (FORCE_RLE ? true : n5 > RLE_MIN_WIDTH && n5 < 0x800000);
        int n6 = n5 + TILE_W >> TILE_W_LG;
        if (n6 > 256) {
            if (DO_STATS) {
                this.rdrStats.stat_array_marlincache_touchedTile.add(n6);
            }
            this.touchedTile = this.touchedTile_ref.getArray(n6);
        }
    }

    void dispose() {
        this.resetTileLine(0);
        if (DO_STATS) {
            this.rdrStats.totalOffHeap += this.rowAAChunk.length;
        }
        this.touchedTile = this.touchedTile_ref.putArray(this.touchedTile, 0, 0);
        if (this.rowAAChunk.length != INITIAL_CHUNK_ARRAY) {
            this.rowAAChunk.resize(INITIAL_CHUNK_ARRAY);
        }
    }

    void resetTileLine(int n) {
        this.bboxY0 = n;
        if (DO_STATS) {
            this.rdrStats.stat_cache_rowAAChunk.add(this.rowAAChunkPos);
        }
        this.rowAAChunkPos = 0L;
        if (this.tileMin != Integer.MAX_VALUE) {
            if (DO_STATS) {
                this.rdrStats.stat_cache_tiles.add(this.tileMax - this.tileMin);
            }
            if (this.tileMax == 1) {
                this.touchedTile[0] = 0;
            } else {
                IntArrayCache.fill(this.touchedTile, this.tileMin, this.tileMax, 0);
            }
            this.tileMin = Integer.MAX_VALUE;
            this.tileMax = Integer.MIN_VALUE;
        }
    }

    void clearAARow(int n) {
        int n2 = n - this.bboxY0;
        this.rowAAx0[n2] = 0;
        this.rowAAx1[n2] = 0;
        this.rowAAEnc[n2] = 0;
    }

    void copyAARowNoRLE(int[] nArray, int n, int n2, int n3) {
        int n4;
        long l;
        long l2;
        int n5 = FloatMath.min(n3, this.bboxX1);
        if (DO_LOG_BOUNDS) {
            MarlinUtils.logInfo("row = [" + n2 + " ... " + n5 + " (" + n3 + ") [ for y=" + n);
        }
        int n6 = n - this.bboxY0;
        this.rowAAx0[n6] = n2;
        this.rowAAx1[n6] = n5;
        this.rowAAEnc[n6] = 0;
        this.rowAAChunkIndex[n6] = l2 = this.rowAAChunkPos;
        this.rowAAChunkPos = l = l2 + (long)(n5 - n2 + 3 & 0xFFFFFFFC);
        OffHeapArray offHeapArray = this.rowAAChunk;
        if (offHeapArray.length < l) {
            this.expandRowAAChunk(l);
        }
        if (DO_STATS) {
            this.rdrStats.stat_cache_rowAA.add(n5 - n2);
        }
        int[] nArray2 = this.touchedTile;
        int n7 = TILE_W_LG;
        int n8 = n2 - this.bboxX0;
        int n9 = n5 - this.bboxX0;
        Unsafe unsafe = OffHeapArray.UNSAFE;
        long l3 = MarlinCache.ALPHA_MAP_UNSAFE.address;
        long l4 = offHeapArray.address + l2;
        int n10 = 0;
        for (n4 = n8; n4 < n9; ++n4) {
            if ((n10 += nArray[n4]) == 0) {
                unsafe.putByte(l4, (byte)0);
            } else {
                unsafe.putByte(l4, unsafe.getByte(l3 + (long)n10));
                int n11 = n4 >> n7;
                nArray2[n11] = nArray2[n11] + n10;
            }
            ++l4;
        }
        n4 = n8 >> n7;
        if (n4 < this.tileMin) {
            this.tileMin = n4;
        }
        if ((n4 = (n9 - 1 >> n7) + 1) > this.tileMax) {
            this.tileMax = n4;
        }
        if (DO_LOG_BOUNDS) {
            MarlinUtils.logInfo("clear = [" + n8 + " ... " + n9 + "[");
        }
        IntArrayCache.fill(nArray, n8, n3 + 1 - this.bboxX0, 0);
    }

    void copyAARowRLE_WithBlockFlags(int[] nArray, int[] nArray2, int n, int n2, int n3) {
        int n4;
        int n5;
        int n6 = this.bboxX0;
        int n7 = n - this.bboxY0;
        int n8 = n2 - n6;
        int n9 = FloatMath.min(n3, this.bboxX1);
        int n10 = n9 - n6;
        if (DO_LOG_BOUNDS) {
            MarlinUtils.logInfo("row = [" + n2 + " ... " + n9 + " (" + n3 + ") [ for y=" + n);
        }
        long l = this.startRLERow(n7, n2, n9);
        long l2 = l + (long)(n10 - n8 << 2);
        OffHeapArray offHeapArray = this.rowAAChunk;
        if (offHeapArray.length < l2) {
            this.expandRowAAChunk(l2);
        }
        Unsafe unsafe = OffHeapArray.UNSAFE;
        long l3 = MarlinCache.ALPHA_MAP_UNSAFE.address;
        long l4 = offHeapArray.address + l;
        int[] nArray3 = this.touchedTile;
        int n11 = TILE_W_LG;
        int n12 = BLOCK_SIZE_LG;
        int n13 = n8 >> n12;
        int n14 = (n10 >> n12) + 1;
        nArray[n14] = 0;
        int n15 = 0;
        int n16 = n8;
        int n17 = Integer.MAX_VALUE;
        int n18 = 0;
        for (int i = n13; i <= n14; ++i) {
            if (nArray[i] != 0) {
                nArray[i] = 0;
                if (n17 != Integer.MAX_VALUE) continue;
                n17 = i;
                continue;
            }
            if (n17 != Integer.MAX_VALUE) {
                int n19 = FloatMath.max(n17 << n12, n8);
                n17 = Integer.MAX_VALUE;
                n5 = FloatMath.min((i << n12) + 1, n10);
                for (int j = n19; j < n5; ++j) {
                    int n20 = nArray2[j];
                    if (n20 == 0) continue;
                    nArray2[j] = 0;
                    if (j != n16) {
                        n4 = j - n16;
                        if (n15 == 0) {
                            unsafe.putInt(l4, n6 + j << 8);
                        } else {
                            unsafe.putInt(l4, n6 + j << 8 | unsafe.getByte(l3 + (long)n15) & 0xFF);
                            if (n4 == 1) {
                                int n21 = n16 >> n11;
                                nArray3[n21] = nArray3[n21] + n15;
                            } else {
                                this.touchTile(n16, n15, j, n4, nArray3);
                            }
                        }
                        l4 += 4L;
                        if (DO_STATS) {
                            this.rdrStats.hist_tile_generator_encoding_runLen.add(n4);
                        }
                        n16 = j;
                    }
                    n15 += n20;
                }
                continue;
            }
            if (!DO_STATS) continue;
            ++n18;
        }
        n4 = n10 - n16;
        if (n15 == 0) {
            unsafe.putInt(l4, n6 + n10 << 8);
        } else {
            unsafe.putInt(l4, n6 + n10 << 8 | unsafe.getByte(l3 + (long)n15) & 0xFF);
            if (n4 == 1) {
                int n22 = n16 >> n11;
                nArray3[n22] = nArray3[n22] + n15;
            } else {
                this.touchTile(n16, n15, n10, n4, nArray3);
            }
        }
        l4 += 4L;
        if (DO_STATS) {
            this.rdrStats.hist_tile_generator_encoding_runLen.add(n4);
        }
        long l5 = l4 - offHeapArray.address;
        this.rowAALen[n7] = l5 - l;
        this.rowAAChunkPos = l5;
        if (DO_STATS) {
            this.rdrStats.stat_cache_rowAA.add(this.rowAALen[n7]);
            this.rdrStats.hist_tile_generator_encoding_ratio.add(100 * n18 / (n14 - n13));
        }
        if ((n5 = n8 >> n11) < this.tileMin) {
            this.tileMin = n5;
        }
        if ((n5 = (n10 - 1 >> n11) + 1) > this.tileMax) {
            this.tileMax = n5;
        }
        nArray2[n10] = 0;
        if (DO_CHECKS) {
            IntArrayCache.check(nArray, n13, n14, 0);
            IntArrayCache.check(nArray2, n8, n3 + 1 - this.bboxX0, 0);
        }
    }

    long startRLERow(int n, int n2, int n3) {
        this.rowAAx0[n] = n2;
        this.rowAAx1[n] = n3;
        this.rowAAEnc[n] = 1;
        this.rowAAPos[n] = 0L;
        this.rowAAChunkIndex[n] = this.rowAAChunkPos;
        return this.rowAAChunkIndex[n];
    }

    private void expandRowAAChunk(long l) {
        if (DO_STATS) {
            this.rdrStats.stat_array_marlincache_rowAAChunk.add(l);
        }
        long l2 = ArrayCacheConst.getNewLargeSize(this.rowAAChunk.length, l);
        this.rowAAChunk.resize(l2);
    }

    private void touchTile(int n, int n2, int n3, int n4, int[] nArray) {
        int n5;
        int n6 = TILE_W_LG;
        int n7 = n >> n6;
        if (n7 == n3 >> n6) {
            int n8 = n7;
            nArray[n8] = nArray[n8] + n2 * n4;
            return;
        }
        int n9 = n3 - 1 >> n6;
        if (n7 <= n9) {
            n5 = n7 + 1 << n6;
            int n10 = n7++;
            nArray[n10] = nArray[n10] + n2 * (n5 - n);
        }
        if (n7 < n9) {
            n5 = n2 << n6;
            while (n7 < n9) {
                int n11 = n7++;
                nArray[n11] = nArray[n11] + n5;
            }
        }
        if (n7 == n9) {
            n5 = n7 << n6;
            int n12 = n7 + 1 << n6;
            int n13 = n12 <= n3 ? n12 : n3;
            int n14 = n7;
            nArray[n14] = nArray[n14] + n2 * (n13 - n5);
        }
    }

    int alphaSumInTile(int n) {
        return this.touchedTile[n - this.bboxX0 >> TILE_W_LG];
    }

    public String toString() {
        return "bbox = [" + this.bboxX0 + ", " + this.bboxY0 + " => " + this.bboxX1 + ", " + this.bboxY1 + "]\n";
    }

    private static byte[] buildAlphaMap(int n) {
        byte[] byArray = new byte[n << 1];
        int n2 = n >> 2;
        for (int i = 0; i <= n; ++i) {
            byArray[i] = (byte)((i * 255 + n2) / n);
        }
        return byArray;
    }

    static {
        byte[] byArray = MarlinCache.buildAlphaMap(MAX_AA_ALPHA);
        ALPHA_MAP_UNSAFE = new OffHeapArray(byArray, byArray.length);
        ALPHA_MAP = byArray;
        Unsafe unsafe = OffHeapArray.UNSAFE;
        long l = MarlinCache.ALPHA_MAP_UNSAFE.address;
        for (int i = 0; i < byArray.length; ++i) {
            unsafe.putByte(l + (long)i, byArray[i]);
        }
    }
}

