/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.cmm.lcms;

import java.util.Arrays;
import java.util.HashMap;
import sun.java2d.cmm.Profile;
import sun.java2d.cmm.lcms.LCMS;

final class LCMSProfile
extends Profile {
    private final TagCache tagCache;
    private final Object disposerReferent;

    LCMSProfile(long l, Object object) {
        super(l);
        this.disposerReferent = object;
        this.tagCache = new TagCache(this);
    }

    final long getLcmsPtr() {
        return this.getNativePtr();
    }

    TagData getTag(int n) {
        return this.tagCache.getTag(n);
    }

    void clearTagCache() {
        this.tagCache.clear();
    }

    static class TagCache {
        final LCMSProfile profile;
        private HashMap<Integer, TagData> tags;

        TagCache(LCMSProfile lCMSProfile) {
            this.profile = lCMSProfile;
            this.tags = new HashMap();
        }

        TagData getTag(int n) {
            byte[] byArray;
            TagData tagData = this.tags.get(n);
            if (tagData == null && (byArray = LCMS.getTagNative(this.profile.getNativePtr(), n)) != null) {
                tagData = new TagData(n, byArray);
                this.tags.put(n, tagData);
            }
            return tagData;
        }

        void clear() {
            this.tags.clear();
        }
    }

    static class TagData {
        private int signature;
        private byte[] data;

        TagData(int n, byte[] byArray) {
            this.signature = n;
            this.data = byArray;
        }

        int getSize() {
            return this.data.length;
        }

        byte[] getData() {
            return Arrays.copyOf(this.data, this.data.length);
        }

        void copyDataTo(byte[] byArray) {
            System.arraycopy(this.data, 0, byArray, 0, this.data.length);
        }

        int getSignature() {
            return this.signature;
        }
    }
}

