/*
 * Decompiled with CFR 0.152.
 */
package jdk.xml.internal;

import com.sun.org.apache.xalan.internal.xsltc.trax.TransformerFactoryImpl;
import com.sun.org.apache.xerces.internal.jaxp.DocumentBuilderFactoryImpl;
import com.sun.org.apache.xerces.internal.jaxp.SAXParserFactoryImpl;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.sax.SAXTransformerFactory;
import jdk.xml.internal.SecuritySupport;
import jdk.xml.internal.XMLSecurityManager;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class JdkXmlUtils {
    private static final String DOM_FACTORY_ID = "javax.xml.parsers.DocumentBuilderFactory";
    private static final String SAX_FACTORY_ID = "javax.xml.parsers.SAXParserFactory";
    private static final String SAX_DRIVER = "org.xml.sax.driver";
    public static final String NAMESPACES_FEATURE = "http://xml.org/sax/features/namespaces";
    public static final String NAMESPACE_PREFIXES_FEATURE = "http://xml.org/sax/features/namespace-prefixes";
    public static final String OVERRIDE_PARSER = "jdk.xml.overrideDefaultParser";
    public static final boolean OVERRIDE_PARSER_DEFAULT = SecuritySupport.getJAXPSystemProperty(Boolean.class, "jdk.xml.overrideDefaultParser", "false");
    public static final String FEATURE_TRUE = "true";
    public static final String FEATURE_FALSE = "false";
    private static final SAXParserFactory defaultSAXFactory = JdkXmlUtils.getSAXFactory(false);

    public static int getValue(Object value, int defValue) {
        if (value == null) {
            return defValue;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value instanceof String) {
            return Integer.parseInt(String.valueOf(value));
        }
        throw new IllegalArgumentException("Unexpected class: " + value.getClass());
    }

    public static void setXMLReaderPropertyIfSupport(XMLReader reader, String property, Object value, boolean warn) {
        block2: {
            try {
                reader.setProperty(property, value);
            }
            catch (SAXNotRecognizedException | SAXNotSupportedException e) {
                if (!warn) break block2;
                XMLSecurityManager.printWarning(reader.getClass().getName(), property, e);
            }
        }
    }

    public static XMLReader getXMLReader(boolean overrideDefaultParser, boolean secureProcessing) {
        XMLReader reader = null;
        String spSAXDriver = SecuritySupport.getSystemProperty(SAX_DRIVER);
        if (spSAXDriver != null) {
            reader = JdkXmlUtils.getXMLReaderWXMLReaderFactory();
        } else if (overrideDefaultParser) {
            reader = JdkXmlUtils.getXMLReaderWSAXFactory(overrideDefaultParser);
        }
        if (reader != null) {
            if (secureProcessing) {
                try {
                    reader.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", secureProcessing);
                }
                catch (SAXException e) {
                    XMLSecurityManager.printWarning(reader.getClass().getName(), "http://javax.xml.XMLConstants/feature/secure-processing", e);
                }
            }
            try {
                reader.setFeature(NAMESPACES_FEATURE, true);
                reader.setFeature(NAMESPACE_PREFIXES_FEATURE, false);
            }
            catch (SAXException sAXException) {
                // empty catch block
            }
            return reader;
        }
        SAXParserFactory saxFactory = defaultSAXFactory;
        try {
            reader = saxFactory.newSAXParser().getXMLReader();
        }
        catch (ParserConfigurationException | SAXException exception) {
            // empty catch block
        }
        return reader;
    }

    public static Document getDOMDocument() {
        try {
            DocumentBuilderFactory dbf = JdkXmlUtils.getDOMFactory(false);
            return dbf.newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            return null;
        }
    }

    public static DocumentBuilderFactory getDOMFactory(boolean overrideDefaultParser) {
        boolean override = overrideDefaultParser;
        String spDOMFactory = SecuritySupport.getJAXPSystemProperty(DOM_FACTORY_ID);
        if (spDOMFactory != null && System.getSecurityManager() == null) {
            override = true;
        }
        DocumentBuilderFactory dbf = !override ? new DocumentBuilderFactoryImpl() : DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        dbf.setValidating(false);
        return dbf;
    }

    public static SAXParserFactory getSAXFactory(boolean overrideDefaultParser) {
        boolean override = overrideDefaultParser;
        String spSAXFactory = SecuritySupport.getJAXPSystemProperty(SAX_FACTORY_ID);
        if (spSAXFactory != null && System.getSecurityManager() == null) {
            override = true;
        }
        SAXParserFactory factory = !override ? new SAXParserFactoryImpl() : SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        return factory;
    }

    public static SAXTransformerFactory getSAXTransformFactory(boolean overrideDefaultParser) {
        SAXTransformerFactory tf = overrideDefaultParser ? (SAXTransformerFactory)SAXTransformerFactory.newInstance() : new TransformerFactoryImpl();
        try {
            tf.setFeature(OVERRIDE_PARSER, overrideDefaultParser);
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            // empty catch block
        }
        return tf;
    }

    public static String getDTDExternalDecl(String publicId, String systemId) {
        StringBuilder sb = new StringBuilder();
        if (null != publicId) {
            sb.append(" PUBLIC ");
            sb.append(JdkXmlUtils.quoteString(publicId));
        }
        if (null != systemId) {
            if (null == publicId) {
                sb.append(" SYSTEM ");
            } else {
                sb.append(" ");
            }
            sb.append(JdkXmlUtils.quoteString(systemId));
        }
        return sb.toString();
    }

    private static String quoteString(String s) {
        char c = s.indexOf(34) > -1 ? (char)'\'' : '\"';
        return c + s + c;
    }

    private static XMLReader getXMLReaderWSAXFactory(boolean overrideDefaultParser) {
        SAXParserFactory saxFactory = JdkXmlUtils.getSAXFactory(overrideDefaultParser);
        try {
            return saxFactory.newSAXParser().getXMLReader();
        }
        catch (ParserConfigurationException | SAXException ex) {
            return JdkXmlUtils.getXMLReaderWXMLReaderFactory();
        }
    }

    private static XMLReader getXMLReaderWXMLReaderFactory() {
        try {
            return XMLReaderFactory.createXMLReader();
        }
        catch (SAXException sAXException) {
            return null;
        }
    }
}

