/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.AlphaComposite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ByteLookupTable;
import java.awt.image.ColorConvertOp;
import java.awt.image.ColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.IndexColorModel;
import java.awt.image.LookupOp;
import java.awt.image.Raster;
import java.awt.image.RasterOp;
import java.awt.image.SampleModel;
import java.awt.image.ShortLookupTable;
import java.awt.image.WritableRaster;
import sun.awt.image.ImagingLib;

public class RescaleOp
implements BufferedImageOp,
RasterOp {
    float[] scaleFactors;
    float[] offsets;
    int length = 0;
    RenderingHints hints;
    private int srcNbits;
    private int dstNbits;

    public RescaleOp(float[] fArray, float[] fArray2, RenderingHints renderingHints) {
        this.length = fArray.length;
        if (this.length > fArray2.length) {
            this.length = fArray2.length;
        }
        this.scaleFactors = new float[this.length];
        this.offsets = new float[this.length];
        for (int i = 0; i < this.length; ++i) {
            this.scaleFactors[i] = fArray[i];
            this.offsets[i] = fArray2[i];
        }
        this.hints = renderingHints;
    }

    public RescaleOp(float f, float f2, RenderingHints renderingHints) {
        this.length = 1;
        this.scaleFactors = new float[1];
        this.offsets = new float[1];
        this.scaleFactors[0] = f;
        this.offsets[0] = f2;
        this.hints = renderingHints;
    }

    public final float[] getScaleFactors(float[] fArray) {
        if (fArray == null) {
            return (float[])this.scaleFactors.clone();
        }
        System.arraycopy(this.scaleFactors, 0, fArray, 0, Math.min(this.scaleFactors.length, fArray.length));
        return fArray;
    }

    public final float[] getOffsets(float[] fArray) {
        if (fArray == null) {
            return (float[])this.offsets.clone();
        }
        System.arraycopy(this.offsets, 0, fArray, 0, Math.min(this.offsets.length, fArray.length));
        return fArray;
    }

    public final int getNumFactors() {
        return this.length;
    }

    private ByteLookupTable createByteLut(float[] fArray, float[] fArray2, int n, int n2) {
        int n3;
        int n4;
        byte[][] byArray = new byte[n][n2];
        for (n4 = 0; n4 < fArray.length; ++n4) {
            float f = fArray[n4];
            float f2 = fArray2[n4];
            byte[] byArray2 = byArray[n4];
            for (int i = 0; i < n2; ++i) {
                int n5 = (int)((float)i * f + f2);
                if ((n5 & 0xFFFFFF00) != 0) {
                    n5 = n5 < 0 ? 0 : 255;
                }
                byArray2[i] = (byte)n5;
            }
        }
        int n6 = n3 = n == 4 && fArray.length == 4 ? 4 : 3;
        while (n4 < byArray.length && n4 < n3) {
            System.arraycopy(byArray[n4 - 1], 0, byArray[n4], 0, n2);
            ++n4;
        }
        if (n == 4 && n4 < n) {
            byte[] byArray3 = byArray[n4];
            for (int i = 0; i < n2; ++i) {
                byArray3[i] = (byte)i;
            }
        }
        return new ByteLookupTable(0, byArray);
    }

    private ShortLookupTable createShortLut(float[] fArray, float[] fArray2, int n, int n2) {
        int n3;
        short[][] sArray = new short[n][n2];
        int n4 = 0;
        for (n4 = 0; n4 < fArray.length; ++n4) {
            float f = fArray[n4];
            float f2 = fArray2[n4];
            short[] sArray2 = sArray[n4];
            for (int i = 0; i < n2; ++i) {
                int n5 = (int)((float)i * f + f2);
                if ((n5 & 0xFFFF0000) != 0) {
                    n5 = n5 < 0 ? 0 : 65535;
                }
                sArray2[i] = (short)n5;
            }
        }
        int n6 = n3 = n == 4 && fArray.length == 4 ? 4 : 3;
        while (n4 < sArray.length && n4 < n3) {
            System.arraycopy(sArray[n4 - 1], 0, sArray[n4], 0, n2);
            ++n4;
        }
        if (n == 4 && n4 < n) {
            short[] sArray3 = sArray[n4];
            for (int i = 0; i < n2; ++i) {
                sArray3[i] = (short)i;
            }
        }
        return new ShortLookupTable(0, sArray);
    }

    private boolean canUseLookup(Raster raster, Raster raster2) {
        ComponentSampleModel componentSampleModel;
        ComponentSampleModel componentSampleModel2;
        int n;
        int n2 = raster.getDataBuffer().getDataType();
        if (n2 != 0 && n2 != 1) {
            return false;
        }
        SampleModel sampleModel = raster2.getSampleModel();
        this.dstNbits = sampleModel.getSampleSize(0);
        if (this.dstNbits != 8 && this.dstNbits != 16) {
            return false;
        }
        for (int i = 1; i < raster.getNumBands(); ++i) {
            n = sampleModel.getSampleSize(i);
            if (n == this.dstNbits) continue;
            return false;
        }
        SampleModel sampleModel2 = raster.getSampleModel();
        this.srcNbits = sampleModel2.getSampleSize(0);
        if (this.srcNbits > 16) {
            return false;
        }
        for (n = 1; n < raster.getNumBands(); ++n) {
            int n3 = sampleModel2.getSampleSize(n);
            if (n3 == this.srcNbits) continue;
            return false;
        }
        if (sampleModel instanceof ComponentSampleModel && (componentSampleModel2 = (ComponentSampleModel)sampleModel).getPixelStride() != raster2.getNumBands()) {
            return false;
        }
        return !(sampleModel2 instanceof ComponentSampleModel) || (componentSampleModel = (ComponentSampleModel)sampleModel2).getPixelStride() == raster.getNumBands();
    }

    @Override
    public final BufferedImage filter(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        Object object;
        ColorModel colorModel = bufferedImage.getColorModel();
        int n = colorModel.getNumColorComponents();
        if (colorModel instanceof IndexColorModel) {
            throw new IllegalArgumentException("Rescaling cannot be performed on an indexed image");
        }
        if (this.length != 1 && this.length != n && this.length != colorModel.getNumComponents()) {
            throw new IllegalArgumentException("Number of scaling constants does not equal the number of of color or color/alpha  components");
        }
        boolean bl = false;
        boolean bl2 = false;
        if (this.length > n && colorModel.hasAlpha()) {
            this.length = n + 1;
        }
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        if (bufferedImage2 == null) {
            bufferedImage2 = this.createCompatibleDestImage(bufferedImage, null);
            ColorModel colorModel2 = colorModel;
        } else {
            if (n2 != bufferedImage2.getWidth()) {
                throw new IllegalArgumentException("Src width (" + n2 + ") not equal to dst width (" + bufferedImage2.getWidth() + ")");
            }
            if (n3 != bufferedImage2.getHeight()) {
                throw new IllegalArgumentException("Src height (" + n3 + ") not equal to dst height (" + bufferedImage2.getHeight() + ")");
            }
            ColorModel colorModel3 = bufferedImage2.getColorModel();
            if (colorModel.getColorSpace().getType() != colorModel3.getColorSpace().getType()) {
                bl = true;
                bufferedImage2 = this.createCompatibleDestImage(bufferedImage, null);
            }
        }
        BufferedImage bufferedImage3 = bufferedImage2;
        if (ImagingLib.filter(this, bufferedImage, bufferedImage2) == null) {
            if (bufferedImage.getRaster().getNumBands() != bufferedImage2.getRaster().getNumBands()) {
                bl2 = true;
                bufferedImage2 = this.createCompatibleDestImage(bufferedImage, null);
            }
            object = bufferedImage.getRaster();
            WritableRaster writableRaster = bufferedImage2.getRaster();
            this.filterRasterImpl((Raster)object, writableRaster, this.length, false);
        }
        if (bl2) {
            object = bufferedImage3.createGraphics();
            ((Graphics2D)object).setComposite(AlphaComposite.Src);
            ((Graphics)object).drawImage(bufferedImage2, 0, 0, n2, n3, null);
            ((Graphics)object).dispose();
        }
        if (bl) {
            object = new ColorConvertOp(this.hints);
            ((ColorConvertOp)object).filter(bufferedImage2, bufferedImage3);
        }
        return bufferedImage3;
    }

    @Override
    public final WritableRaster filter(Raster raster, WritableRaster writableRaster) {
        return this.filterRasterImpl(raster, writableRaster, this.length, true);
    }

    private WritableRaster filterRasterImpl(Raster raster, WritableRaster writableRaster, int n, boolean bl) {
        int n2 = raster.getNumBands();
        int n3 = raster.getWidth();
        int n4 = raster.getHeight();
        int[] nArray = null;
        int n5 = 0;
        int n6 = 0;
        if (writableRaster == null) {
            writableRaster = this.createCompatibleDestRaster(raster);
        } else {
            if (n4 != writableRaster.getHeight() || n3 != writableRaster.getWidth()) {
                throw new IllegalArgumentException("Width or height of Rasters do not match");
            }
            if (n2 != writableRaster.getNumBands()) {
                throw new IllegalArgumentException("Number of bands in src " + n2 + " does not equal number of bands in dest " + writableRaster.getNumBands());
            }
        }
        if (bl && n != 1 && n != raster.getNumBands()) {
            throw new IllegalArgumentException("Number of scaling constants does not equal the number of of bands in the src raster");
        }
        if (ImagingLib.filter(this, raster, writableRaster) != null) {
            return writableRaster;
        }
        if (this.canUseLookup(raster, writableRaster)) {
            int n7 = 1 << this.srcNbits;
            int n8 = 1 << this.dstNbits;
            if (n8 == 256) {
                ByteLookupTable byteLookupTable = this.createByteLut(this.scaleFactors, this.offsets, n2, n7);
                LookupOp lookupOp = new LookupOp(byteLookupTable, this.hints);
                lookupOp.filter(raster, writableRaster);
            } else {
                ShortLookupTable shortLookupTable = this.createShortLut(this.scaleFactors, this.offsets, n2, n7);
                LookupOp lookupOp = new LookupOp(shortLookupTable, this.hints);
                lookupOp.filter(raster, writableRaster);
            }
        } else {
            int n9;
            if (this.length > 1) {
                n5 = 1;
            }
            int n10 = raster.getMinX();
            int n11 = raster.getMinY();
            int n12 = writableRaster.getMinX();
            int n13 = writableRaster.getMinY();
            int[] nArray2 = new int[n2];
            int[] nArray3 = new int[n2];
            SampleModel sampleModel = writableRaster.getSampleModel();
            for (n9 = 0; n9 < n2; ++n9) {
                int n14 = sampleModel.getSampleSize(n9);
                nArray2[n9] = (1 << n14) - 1;
                nArray3[n9] = ~nArray2[n9];
            }
            int n15 = 0;
            while (n15 < n4) {
                int n16 = n12;
                int n17 = n10;
                int n18 = 0;
                while (n18 < n3) {
                    nArray = raster.getPixel(n17, n11, nArray);
                    n6 = 0;
                    int n19 = 0;
                    while (n19 < n2) {
                        n9 = (n == 1 || n == 3) && n19 == 3 && n2 == 4 ? nArray[n19] : (int)((float)nArray[n19] * this.scaleFactors[n6] + this.offsets[n6]);
                        if ((n9 & nArray3[n19]) != 0) {
                            n9 = n9 < 0 ? 0 : nArray2[n19];
                        }
                        nArray[n19] = n9;
                        ++n19;
                        n6 += n5;
                    }
                    writableRaster.setPixel(n16, n13, nArray);
                    ++n18;
                    ++n17;
                    ++n16;
                }
                ++n15;
                ++n11;
                ++n13;
            }
        }
        return writableRaster;
    }

    @Override
    public final Rectangle2D getBounds2D(BufferedImage bufferedImage) {
        return this.getBounds2D(bufferedImage.getRaster());
    }

    @Override
    public final Rectangle2D getBounds2D(Raster raster) {
        return raster.getBounds();
    }

    @Override
    public BufferedImage createCompatibleDestImage(BufferedImage bufferedImage, ColorModel colorModel) {
        BufferedImage bufferedImage2;
        if (colorModel == null) {
            ColorModel colorModel2 = bufferedImage.getColorModel();
            bufferedImage2 = new BufferedImage(colorModel2, bufferedImage.getRaster().createCompatibleWritableRaster(), colorModel2.isAlphaPremultiplied(), null);
        } else {
            int n = bufferedImage.getWidth();
            int n2 = bufferedImage.getHeight();
            bufferedImage2 = new BufferedImage(colorModel, colorModel.createCompatibleWritableRaster(n, n2), colorModel.isAlphaPremultiplied(), null);
        }
        return bufferedImage2;
    }

    @Override
    public WritableRaster createCompatibleDestRaster(Raster raster) {
        return raster.createCompatibleWritableRaster(raster.getWidth(), raster.getHeight());
    }

    @Override
    public final Point2D getPoint2D(Point2D point2D, Point2D point2D2) {
        if (point2D2 == null) {
            point2D2 = new Point2D.Float();
        }
        point2D2.setLocation(point2D.getX(), point2D.getY());
        return point2D2;
    }

    @Override
    public final RenderingHints getRenderingHints() {
        return this.hints;
    }
}

