/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.keys.content.keyvalues;

import com.sun.org.apache.xml.internal.security.exceptions.XMLSecurityException;
import com.sun.org.apache.xml.internal.security.keys.content.keyvalues.KeyValueContent;
import com.sun.org.apache.xml.internal.security.utils.I18n;
import com.sun.org.apache.xml.internal.security.utils.Signature11ElementProxy;
import com.sun.org.apache.xml.internal.security.utils.XMLUtils;
import java.io.IOException;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECFieldFp;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.EllipticCurve;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.util.Arrays;
import javax.xml.crypto.MarshalException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class ECKeyValue
extends Signature11ElementProxy
implements KeyValueContent {
    private static final Curve SECP256R1 = ECKeyValue.initializeCurve("secp256r1 [NIST P-256, X9.62 prime256v1]", "1.2.840.10045.3.1.7", "FFFFFFFF00000001000000000000000000000000FFFFFFFFFFFFFFFFFFFFFFFF", "FFFFFFFF00000001000000000000000000000000FFFFFFFFFFFFFFFFFFFFFFFC", "5AC635D8AA3A93E7B3EBBD55769886BC651D06B0CC53B0F63BCE3C3E27D2604B", "6B17D1F2E12C4247F8BCE6E563A440F277037D812DEB33A0F4A13945D898C296", "4FE342E2FE1A7F9B8EE7EB4A7C0F9E162BCE33576B315ECECBB6406837BF51F5", "FFFFFFFF00000000FFFFFFFFFFFFFFFFBCE6FAADA7179E84F3B9CAC2FC632551", 1);
    private static final Curve SECP384R1 = ECKeyValue.initializeCurve("secp384r1 [NIST P-384]", "1.3.132.0.34", "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFFFFFFFF0000000000000000FFFFFFFF", "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFFFFFFFF0000000000000000FFFFFFFC", "B3312FA7E23EE7E4988E056BE3F82D19181D9C6EFE8141120314088F5013875AC656398D8A2ED19D2A85C8EDD3EC2AEF", "AA87CA22BE8B05378EB1C71EF320AD746E1D3B628BA79B9859F741E082542A385502F25DBF55296C3A545E3872760AB7", "3617DE4A96262C6F5D9E98BF9292DC29F8F41DBD289A147CE9DA3113B5F0B8C00A60B1CE1D7E819D7A431D7C90EA0E5F", "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC7634D81F4372DDF581A0DB248B0A77AECEC196ACCC52973", 1);
    private static final Curve SECP521R1 = ECKeyValue.initializeCurve("secp521r1 [NIST P-521]", "1.3.132.0.35", "01FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF", "01FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC", "0051953EB9618E1C9A1F929A21A0B68540EEA2DA725B99B315F3B8B489918EF109E156193951EC7E937B1652C0BD3BB1BF073573DF883D2C34F1EF451FD46B503F00", "00C6858E06B70404E9CD9E3ECB662395B4429C648139053FB521F828AF606B4D3DBAA14B5E77EFE75928FE1DC127A2FFA8DE3348B3C1856A429BF97E7E31C2E5BD66", "011839296A789A3BC0045C8A5FB42C7D1BD998F54449579B446817AFBD17273E662C97EE72995EF42640C550B9013FAD0761353C7086A272C24088BE94769FD16650", "01FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFA51868783BF2F966B7FCC0148F709A5D03BB5C9B8899C47AEBB6FB71E91386409", 1);

    private static Curve initializeCurve(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, int n) {
        BigInteger bigInteger = ECKeyValue.bigInt(string3);
        ECFieldFp eCFieldFp = new ECFieldFp(bigInteger);
        EllipticCurve ellipticCurve = new EllipticCurve(eCFieldFp, ECKeyValue.bigInt(string4), ECKeyValue.bigInt(string5));
        ECPoint eCPoint = new ECPoint(ECKeyValue.bigInt(string6), ECKeyValue.bigInt(string7));
        return new Curve(string, string2, ellipticCurve, eCPoint, ECKeyValue.bigInt(string8), n);
    }

    public ECKeyValue(Element element, String string) throws XMLSecurityException {
        super(element, string);
    }

    public ECKeyValue(Document document, Key key) throws IllegalArgumentException {
        super(document);
        String string;
        ECParameterSpec eCParameterSpec;
        this.addReturnToSelf();
        if (key instanceof ECPublicKey) {
            eCParameterSpec = ((ECPublicKey)key).getParams();
            string = ECKeyValue.getCurveOid(eCParameterSpec);
            if (string == null) {
                throw new IllegalArgumentException("Invalid ECParameterSpec");
            }
        } else {
            Object[] objectArray = new Object[]{"ECKeyValue", key.getClass().getName()};
            throw new IllegalArgumentException(I18n.translate("KeyValue.IllegalArgument", objectArray));
        }
        Element element = XMLUtils.createElementInSignature11Space(this.getDocument(), "NamedCurve");
        element.setAttributeNS(null, "URI", "urn:oid:" + string);
        this.appendSelf(element);
        this.addReturnToSelf();
        ECPoint eCPoint = ((ECPublicKey)key).getW();
        byte[] byArray = ECKeyValue.encodePoint(eCPoint, eCParameterSpec.getCurve());
        String string2 = XMLUtils.encodeToString(byArray);
        Element element2 = XMLUtils.createElementInSignature11Space(this.getDocument(), "PublicKey");
        Text text = this.getDocument().createTextNode(string2);
        element2.appendChild(text);
        this.appendSelf(element2);
        this.addReturnToSelf();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public PublicKey getPublicKey() throws XMLSecurityException {
        try {
            ECParameterSpec eCParameterSpec = null;
            Element element = ECKeyValue.getFirstChildElement(this.getElement());
            if (element == null) {
                throw new MarshalException("KeyValue must contain at least one type");
            }
            if ("ECParameters".equals(element.getLocalName()) && "http://www.w3.org/2009/xmldsig11#".equals(element.getNamespaceURI())) {
                throw new UnsupportedOperationException("ECParameters not supported");
            }
            if (!"NamedCurve".equals(element.getLocalName()) || !"http://www.w3.org/2009/xmldsig11#".equals(element.getNamespaceURI())) throw new MarshalException("Invalid ECKeyValue");
            Object object = null;
            if (element.hasAttributeNS(null, "URI")) {
                object = element.getAttributeNS(null, "URI");
            }
            if (object == null || !((String)object).startsWith("urn:oid:")) throw new MarshalException("Invalid NamedCurve URI");
            Object object2 = ((String)object).substring("urn:oid:".length());
            eCParameterSpec = ECKeyValue.getECParameterSpec((String)object2);
            if (eCParameterSpec == null) {
                throw new MarshalException("Invalid curve OID");
            }
            element = ECKeyValue.getNextSiblingElement(element, "PublicKey", "http://www.w3.org/2009/xmldsig11#");
            object = null;
            try {
                object2 = XMLUtils.getFullTextChildrenFromNode(element);
                object = ECKeyValue.decodePoint(XMLUtils.decode((String)object2), eCParameterSpec.getCurve());
            }
            catch (IOException iOException) {
                throw new MarshalException("Invalid EC Point", iOException);
            }
            object2 = new ECPublicKeySpec((ECPoint)object, eCParameterSpec);
            return KeyFactory.getInstance("EC").generatePublic((KeySpec)object2);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException | MarshalException exception) {
            throw new XMLSecurityException(exception);
        }
    }

    @Override
    public String getBaseLocalName() {
        return "ECKeyValue";
    }

    private static Element getFirstChildElement(Node node) {
        Node node2;
        for (node2 = node.getFirstChild(); node2 != null && node2.getNodeType() != 1; node2 = node2.getNextSibling()) {
        }
        return (Element)node2;
    }

    private static Element getNextSiblingElement(Node node, String string, String string2) throws MarshalException {
        return ECKeyValue.verifyElement(ECKeyValue.getNextSiblingElement(node), string, string2);
    }

    private static Element getNextSiblingElement(Node node) {
        Node node2;
        for (node2 = node.getNextSibling(); node2 != null && node2.getNodeType() != 1; node2 = node2.getNextSibling()) {
        }
        return (Element)node2;
    }

    private static Element verifyElement(Element element, String string, String string2) throws MarshalException {
        if (element == null) {
            throw new MarshalException("Missing " + string + " element");
        }
        String string3 = element.getLocalName();
        String string4 = element.getNamespaceURI();
        if (!string3.equals(string) || string4 == null && string2 != null || string4 != null && !string4.equals(string2)) {
            throw new MarshalException("Invalid element name: " + string4 + ":" + string3 + ", expected " + string2 + ":" + string);
        }
        return element;
    }

    private static String getCurveOid(ECParameterSpec eCParameterSpec) {
        Curve curve;
        if (ECKeyValue.matchCurve(eCParameterSpec, SECP256R1)) {
            curve = SECP256R1;
        } else if (ECKeyValue.matchCurve(eCParameterSpec, SECP384R1)) {
            curve = SECP384R1;
        } else if (ECKeyValue.matchCurve(eCParameterSpec, SECP521R1)) {
            curve = SECP521R1;
        } else {
            return null;
        }
        return curve.getObjectId();
    }

    private static boolean matchCurve(ECParameterSpec eCParameterSpec, Curve curve) {
        int n = eCParameterSpec.getCurve().getField().getFieldSize();
        return curve.getCurve().getField().getFieldSize() == n && curve.getCurve().equals(eCParameterSpec.getCurve()) && curve.getGenerator().equals(eCParameterSpec.getGenerator()) && curve.getOrder().equals(eCParameterSpec.getOrder()) && curve.getCofactor() == eCParameterSpec.getCofactor();
    }

    private static ECPoint decodePoint(byte[] byArray, EllipticCurve ellipticCurve) throws IOException {
        if (byArray.length == 0 || byArray[0] != 4) {
            throw new IOException("Only uncompressed point format supported");
        }
        int n = (byArray.length - 1) / 2;
        if (n != ellipticCurve.getField().getFieldSize() + 7 >> 3) {
            throw new IOException("Point does not match field size");
        }
        byte[] byArray2 = Arrays.copyOfRange(byArray, 1, 1 + n);
        byte[] byArray3 = Arrays.copyOfRange(byArray, n + 1, n + 1 + n);
        return new ECPoint(new BigInteger(1, byArray2), new BigInteger(1, byArray3));
    }

    private static byte[] encodePoint(ECPoint eCPoint, EllipticCurve ellipticCurve) {
        int n = ellipticCurve.getField().getFieldSize() + 7 >> 3;
        byte[] byArray = ECKeyValue.trimZeroes(eCPoint.getAffineX().toByteArray());
        byte[] byArray2 = ECKeyValue.trimZeroes(eCPoint.getAffineY().toByteArray());
        if (byArray.length > n || byArray2.length > n) {
            throw new RuntimeException("Point coordinates do not match field size");
        }
        byte[] byArray3 = new byte[1 + (n << 1)];
        byArray3[0] = 4;
        System.arraycopy(byArray, 0, byArray3, n - byArray.length + 1, byArray.length);
        System.arraycopy(byArray2, 0, byArray3, byArray3.length - byArray2.length, byArray2.length);
        return byArray3;
    }

    private static byte[] trimZeroes(byte[] byArray) {
        int n;
        for (n = 0; n < byArray.length - 1 && byArray[n] == 0; ++n) {
        }
        if (n == 0) {
            return byArray;
        }
        return Arrays.copyOfRange(byArray, n, byArray.length);
    }

    private static ECParameterSpec getECParameterSpec(String string) {
        if (string.equals(ECKeyValue.SECP256R1.getObjectId())) {
            return SECP256R1;
        }
        if (string.equals(ECKeyValue.SECP384R1.getObjectId())) {
            return SECP384R1;
        }
        if (string.equals(ECKeyValue.SECP521R1.getObjectId())) {
            return SECP521R1;
        }
        return null;
    }

    private static BigInteger bigInt(String string) {
        return new BigInteger(string, 16);
    }

    static final class Curve
    extends ECParameterSpec {
        private final String name;
        private final String oid;

        Curve(String string, String string2, EllipticCurve ellipticCurve, ECPoint eCPoint, BigInteger bigInteger, int n) {
            super(ellipticCurve, eCPoint, bigInteger, n);
            this.name = string;
            this.oid = string2;
        }

        private String getName() {
            return this.name;
        }

        private String getObjectId() {
            return this.oid;
        }
    }
}

