/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security;

import com.sun.org.apache.xml.internal.security.algorithms.JCEMapper;
import com.sun.org.apache.xml.internal.security.algorithms.SignatureAlgorithm;
import com.sun.org.apache.xml.internal.security.c14n.Canonicalizer;
import com.sun.org.apache.xml.internal.security.exceptions.XMLSecurityException;
import com.sun.org.apache.xml.internal.security.keys.keyresolver.KeyResolver;
import com.sun.org.apache.xml.internal.security.transforms.Transform;
import com.sun.org.apache.xml.internal.security.utils.ElementProxy;
import com.sun.org.apache.xml.internal.security.utils.I18n;
import com.sun.org.apache.xml.internal.security.utils.XMLUtils;
import com.sun.org.apache.xml.internal.security.utils.resolver.ResourceResolver;
import com.sun.org.slf4j.internal.Logger;
import com.sun.org.slf4j.internal.LoggerFactory;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Init {
    public static final String CONF_NS = "http://www.xmlsecurity.org/NS/#configuration";
    private static final Logger LOG = LoggerFactory.getLogger(Init.class);
    private static boolean alreadyInitialized = false;

    public static final synchronized boolean isInitialized() {
        return alreadyInitialized;
    }

    public static synchronized void init() {
        if (alreadyInitialized) {
            return;
        }
        InputStream inputStream = AccessController.doPrivileged(() -> {
            String string = System.getProperty("com.sun.org.apache.xml.internal.security.resource.config");
            if (string == null) {
                return null;
            }
            return Init.getResourceAsStream(string, Init.class);
        });
        if (inputStream == null) {
            Init.dynamicInit();
        } else {
            Init.fileInit(inputStream);
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                LOG.warn(iOException.getMessage());
            }
        }
        alreadyInitialized = true;
    }

    private static void dynamicInit() {
        I18n.init("en", "US");
        LOG.debug("Registering default algorithms");
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws XMLSecurityException {
                    ElementProxy.registerDefaultPrefixes();
                    Transform.registerDefaultAlgorithms();
                    SignatureAlgorithm.registerDefaultAlgorithms();
                    JCEMapper.registerDefaultAlgorithms();
                    Canonicalizer.registerDefaultAlgorithms();
                    ResourceResolver.registerDefaultResolvers();
                    KeyResolver.registerDefaultResolvers();
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            XMLSecurityException xMLSecurityException = (XMLSecurityException)privilegedActionException.getException();
            LOG.error(xMLSecurityException.getMessage(), xMLSecurityException);
            xMLSecurityException.printStackTrace();
        }
    }

    /*
     * Could not resolve type clashes
     */
    private static void fileInit(InputStream inputStream) {
        try {
            Node node;
            Document document = XMLUtils.read(inputStream, true);
            for (node = document.getFirstChild(); node != null && !"Configuration".equals(node.getLocalName()); node = node.getNextSibling()) {
            }
            if (node == null) {
                LOG.error("Error in reading configuration file - Configuration element not found");
                return;
            }
            for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                String string;
                Object[] objectArray;
                String string2;
                Object object6;
                Object object2;
                Object object3;
                if (1 != node2.getNodeType()) continue;
                String string3 = node2.getLocalName();
                if ("ResourceBundles".equals(string3)) {
                    object3 = (Element[])node2;
                    object2 = object3.getAttributeNodeNS(null, "defaultLanguageCode");
                    Object object4 = object3.getAttributeNodeNS(null, "defaultCountryCode");
                    String string4 = object2 == null ? null : object2.getNodeValue();
                    Object object5 = object4 == null ? null : object4.getNodeValue();
                    I18n.init(string4, (String)object5);
                }
                if ("CanonicalizationMethods".equals(string3)) {
                    for (Object object5 : object3 = XMLUtils.selectNodes(node2.getFirstChild(), CONF_NS, "CanonicalizationMethod")) {
                        object6 = object5.getAttributeNS(null, "URI");
                        string2 = object5.getAttributeNS(null, "JAVACLASS");
                        try {
                            Canonicalizer.register((String)object6, string2);
                            LOG.debug("Canonicalizer.register({}, {})", object6, string2);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            objectArray = new Object[]{object6, string2};
                            LOG.error(I18n.translate("algorithm.classDoesNotExist", objectArray));
                        }
                    }
                }
                if ("TransformAlgorithms".equals(string3)) {
                    for (Object object5 : object3 = XMLUtils.selectNodes(node2.getFirstChild(), CONF_NS, "TransformAlgorithm")) {
                        object6 = object5.getAttributeNS(null, "URI");
                        string2 = object5.getAttributeNS(null, "JAVACLASS");
                        try {
                            Transform.register((String)object6, string2);
                            LOG.debug("Transform.register({}, {})", object6, string2);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            objectArray = new Object[]{object6, string2};
                            LOG.error(I18n.translate("algorithm.classDoesNotExist", objectArray));
                        }
                        catch (NoClassDefFoundError noClassDefFoundError) {
                            LOG.warn("Not able to found dependencies for algorithm, I'll keep working.");
                        }
                    }
                }
                if ("JCEAlgorithmMappings".equals(string3) && (object3 = ((Element)node2).getElementsByTagName("Algorithms").item(0)) != null) {
                    object2 = XMLUtils.selectNodes(object3.getFirstChild(), CONF_NS, "Algorithm");
                    for (Object object6 : object2) {
                        string2 = object6.getAttributeNS(null, "URI");
                        JCEMapper.register(string2, new JCEMapper.Algorithm((Element)object6));
                    }
                }
                if ("SignatureAlgorithms".equals(string3)) {
                    for (Object object5 : object3 = XMLUtils.selectNodes(node2.getFirstChild(), CONF_NS, "SignatureAlgorithm")) {
                        object6 = object5.getAttributeNS(null, "URI");
                        string2 = object5.getAttributeNS(null, "JAVACLASS");
                        try {
                            SignatureAlgorithm.register((String)object6, string2);
                            LOG.debug("SignatureAlgorithm.register({}, {})", object6, string2);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            objectArray = new Object[]{object6, string2};
                            LOG.error(I18n.translate("algorithm.classDoesNotExist", objectArray));
                        }
                    }
                }
                if ("ResourceResolvers".equals(string3)) {
                    object3 = XMLUtils.selectNodes(node2.getFirstChild(), CONF_NS, "Resolver");
                    object2 = new ArrayList(((Object)object3).length);
                    for (Object object6 : object3) {
                        string2 = object6.getAttributeNS(null, "JAVACLASS");
                        string = object6.getAttributeNS(null, "DESCRIPTION");
                        if (string != null && string.length() > 0) {
                            LOG.debug("Register Resolver: {}: {}", string2, string);
                        } else {
                            LOG.debug("Register Resolver: {}: For unknown purposes", string2);
                        }
                        object2.add(string2);
                    }
                    ResourceResolver.registerClassNames((List<String>)object2);
                }
                if ("KeyResolver".equals(string3)) {
                    object3 = XMLUtils.selectNodes(node2.getFirstChild(), CONF_NS, "Resolver");
                    object2 = new ArrayList(((Object)object3).length);
                    for (Object object6 : object3) {
                        string2 = object6.getAttributeNS(null, "JAVACLASS");
                        string = object6.getAttributeNS(null, "DESCRIPTION");
                        if (string != null && string.length() > 0) {
                            LOG.debug("Register Resolver: {}: {}", string2, string);
                        } else {
                            LOG.debug("Register Resolver: {}: For unknown purposes", string2);
                        }
                        object2.add(string2);
                    }
                    KeyResolver.registerClassNames((List<String>)object2);
                }
                if (!"PrefixMappings".equals(string3)) continue;
                LOG.debug("Now I try to bind prefixes:");
                for (Object object5 : object3 = XMLUtils.selectNodes(node2.getFirstChild(), CONF_NS, "PrefixMapping")) {
                    object6 = object5.getAttributeNS(null, "namespace");
                    string2 = object5.getAttributeNS(null, "prefix");
                    LOG.debug("Now I try to bind {} to {}", string2, object6);
                    ElementProxy.setDefaultPrefix((String)object6, string2);
                }
            }
        }
        catch (Exception exception) {
            LOG.error("Bad: ", exception);
        }
    }

    public static URL getResource(String string, Class<?> clazz) {
        ClassLoader classLoader;
        ClassLoader classLoader2;
        if (string == null) {
            throw new NullPointerException();
        }
        URL uRL = Thread.currentThread().getContextClassLoader().getResource(string);
        if (uRL == null && string.charAt(0) == '/') {
            uRL = Thread.currentThread().getContextClassLoader().getResource(string.substring(1));
        }
        if ((classLoader2 = Init.class.getClassLoader()) == null) {
            classLoader2 = ClassLoader.getSystemClassLoader();
        }
        if (uRL == null) {
            uRL = classLoader2.getResource(string);
        }
        if (uRL == null && string.charAt(0) == '/') {
            uRL = classLoader2.getResource(string.substring(1));
        }
        if (uRL == null && (classLoader = clazz.getClassLoader()) != null) {
            uRL = classLoader.getResource(string);
        }
        if (uRL == null) {
            uRL = clazz.getResource(string);
        }
        if (uRL == null && string.charAt(0) != '/') {
            return Init.getResource('/' + string, clazz);
        }
        return uRL;
    }

    private static List<URL> getResources(String string, Class<?> clazz) {
        Object object;
        ClassLoader classLoader;
        if (string == null) {
            throw new NullPointerException();
        }
        ArrayList<URL> arrayList = new ArrayList<URL>();
        Enumeration<URL> enumeration = new Enumeration<URL>(){

            @Override
            public boolean hasMoreElements() {
                return false;
            }

            @Override
            public URL nextElement() {
                return null;
            }
        };
        try {
            enumeration = Thread.currentThread().getContextClassLoader().getResources(string);
        }
        catch (IOException iOException) {
            LOG.debug(iOException.getMessage(), iOException);
        }
        if (!enumeration.hasMoreElements() && string.charAt(0) == '/') {
            try {
                enumeration = Thread.currentThread().getContextClassLoader().getResources(string.substring(1));
            }
            catch (IOException iOException) {
                LOG.debug(iOException.getMessage(), iOException);
            }
        }
        if ((classLoader = Init.class.getClassLoader()) == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        if (!enumeration.hasMoreElements()) {
            try {
                enumeration = classLoader.getResources(string);
            }
            catch (IOException iOException) {
                LOG.debug(iOException.getMessage(), iOException);
            }
        }
        if (!enumeration.hasMoreElements() && string.charAt(0) == '/') {
            try {
                enumeration = classLoader.getResources(string.substring(1));
            }
            catch (IOException iOException) {
                LOG.debug(iOException.getMessage(), iOException);
            }
        }
        if (!enumeration.hasMoreElements() && (object = clazz.getClassLoader()) != null) {
            try {
                enumeration = ((ClassLoader)object).getResources(string);
            }
            catch (IOException iOException) {
                LOG.debug(iOException.getMessage(), iOException);
            }
        }
        if (!enumeration.hasMoreElements() && (object = clazz.getResource(string)) != null) {
            arrayList.add((URL)object);
        }
        while (enumeration.hasMoreElements()) {
            arrayList.add(enumeration.nextElement());
        }
        if (arrayList.isEmpty() && string.charAt(0) != '/') {
            return Init.getResources('/' + string, clazz);
        }
        return arrayList;
    }

    private static InputStream getResourceAsStream(String string, Class<?> clazz) {
        URL uRL = Init.getResource(string, clazz);
        try {
            return uRL != null ? uRL.openStream() : null;
        }
        catch (IOException iOException) {
            LOG.debug(iOException.getMessage(), iOException);
            return null;
        }
    }
}

