/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrockit.jfr;

import com.oracle.jrockit.jfr.EventToken;
import java.io.File;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.TimeZone;
import jdk.internal.instrumentation.Logger;
import jdk.internal.instrumentation.Tracer;
import jdk.jfr.events.FileReadEvent;
import jdk.jfr.events.FileWriteEvent;
import jdk.jfr.events.SecurityPropertyModificationEvent;
import jdk.jfr.events.SecurityProviderServiceEvent;
import jdk.jfr.events.SocketReadEvent;
import jdk.jfr.events.SocketWriteEvent;
import jdk.jfr.events.TLSHandshakeEvent;
import jdk.jfr.events.X509CertificateEvent;
import jdk.jfr.events.X509ValidationEvent;
import oracle.jrockit.jfr.DCmdCheck;
import oracle.jrockit.jfr.DCmdDump;
import oracle.jrockit.jfr.DCmdException;
import oracle.jrockit.jfr.DCmdStart;
import oracle.jrockit.jfr.DCmdStop;
import oracle.jrockit.jfr.FileChannelImplInstrumentor;
import oracle.jrockit.jfr.FileInputStreamInstrumentor;
import oracle.jrockit.jfr.FileOutputStreamInstrumentor;
import oracle.jrockit.jfr.FinishedInstrumentor;
import oracle.jrockit.jfr.JCAUtilInstrumentor;
import oracle.jrockit.jfr.JFR;
import oracle.jrockit.jfr.JFRImpl;
import oracle.jrockit.jfr.JFRStats;
import oracle.jrockit.jfr.NativeJFRStats;
import oracle.jrockit.jfr.NativeOptions;
import oracle.jrockit.jfr.NativeProducerDescriptor;
import oracle.jrockit.jfr.Options;
import oracle.jrockit.jfr.PKIXCertPathValidatorInstrumentor;
import oracle.jrockit.jfr.Process;
import oracle.jrockit.jfr.ProducerDescriptor;
import oracle.jrockit.jfr.RandomAccessFileInstrumentor;
import oracle.jrockit.jfr.RepositoryChunk;
import oracle.jrockit.jfr.SecurityInstrumentor;
import oracle.jrockit.jfr.SecurityProviderInstrumentor;
import oracle.jrockit.jfr.SocketChannelImplInstrumentor;
import oracle.jrockit.jfr.SocketInputStreamInstrumentor;
import oracle.jrockit.jfr.SocketOutputStreamInstrumentor;
import oracle.jrockit.jfr.StringConstantPool;
import oracle.jrockit.jfr.ThrowableInstrumentor;
import oracle.jrockit.jfr.Timing;
import oracle.jrockit.jfr.jdkevents.ThrowableTracer;

@Deprecated
public final class VMJFR
extends JFRImpl {
    private final NativeProducerDescriptor vm;
    private final NativeJFRStats jfrStats;
    static final int PREV = 0;
    static final int NEXT = 1 * addressSize;
    static final int START = 2 * addressSize;
    static final int TOP = 3 * addressSize;
    static final int POS = 4 * addressSize;
    static final int END = 5 * addressSize;
    static final int USED = 6 * addressSize;
    static final int RESERVED = USED + 4;
    static final int DATA = RESERVED + 4;
    private final ThreadLocal<ThreadBuffer> bufferLocal = new ThreadLocal<ThreadBuffer>(){

        @Override
        protected ThreadBuffer initialValue() {
            return new ThreadBuffer(VMJFR.this.buffer());
        }
    };
    public static EventToken socketReadToken;
    public static EventToken socketWriteToken;
    public static EventToken fileReadToken;
    public static EventToken fileWriteToken;
    public static EventToken securityProviderToken;
    public static EventToken securityPropertyToken;
    public static EventToken tlsHandshakeToken;
    public static EventToken x509CertificateToken;
    public static EventToken x509ValidationToken;
    private final Class<?>[] instrumentationClasses = new Class[]{FileChannelImplInstrumentor.class, FileInputStreamInstrumentor.class, FileOutputStreamInstrumentor.class, FinishedInstrumentor.class, JCAUtilInstrumentor.class, PKIXCertPathValidatorInstrumentor.class, RandomAccessFileInstrumentor.class, SecurityInstrumentor.class, SecurityProviderInstrumentor.class, SocketChannelImplInstrumentor.class, SocketInputStreamInstrumentor.class, SocketOutputStreamInstrumentor.class};

    VMJFR() throws Throwable {
        super((NativeOptions)VMJFR.options());
        assert (VMJFR.isSupportedInVM());
        assert (VMJFR.isCommercialFeaturesUnlocked());
        assert (VMJFR.isEnabled());
        try {
            ByteBuffer byteBuffer = this.init(Locale.getDefault().toString(), TimeZone.getDefault().getRawOffset(), this.getRepository().getPath().getPath());
            this.jfrStats = new NativeJFRStats(byteBuffer.order(ByteOrder.nativeOrder()));
            this.vm = new NativeProducerDescriptor(1, this);
            this.addProducer(this.vm, this.vm.controls());
            this.logger.trace("VMJFR created.");
        }
        catch (Throwable throwable) {
            this.clear();
            throw throwable;
        }
    }

    private static native Options options();

    private native ByteBuffer init(String var1, int var2, String var3);

    @Override
    public ByteBuffer getThreadBuffer(int n) {
        return this.bufferLocal.get().ensure(n);
    }

    @Override
    public void releaseThreadBuffer(ByteBuffer byteBuffer, boolean bl) {
        this.bufferLocal.get().finish(byteBuffer, bl);
    }

    private native void addConstPool(ByteBuffer var1, int var2, boolean var3);

    private native void removeConstPool(int var1);

    private native boolean storeConstPool(int var1);

    @Override
    protected void addConstpool(StringConstantPool stringConstantPool) {
        this.addConstPool(stringConstantPool.getConstantData(), stringConstantPool.getConstantIndex(), stringConstantPool.emptyOnRotation());
    }

    @Override
    protected void removeConstpool(StringConstantPool stringConstantPool) {
        this.removeConstPool(stringConstantPool.getConstantIndex());
    }

    @Override
    protected boolean storeConstpool(StringConstantPool stringConstantPool) {
        return this.storeConstPool(stringConstantPool.getConstantIndex());
    }

    @Override
    public long classID(Class<?> clazz) {
        if (clazz == null) {
            return 0L;
        }
        return this.classID0(clazz);
    }

    private native long classID0(Class<?> var1);

    @Override
    public long counterTime() {
        return Timing.counterTime();
    }

    @Override
    public long nanoToCounter(long l) {
        return Timing.nanoToCounter(l);
    }

    @Override
    public native long stackTraceID(int var1);

    @Override
    public native int threadID();

    @Override
    public int getpid() {
        return Process.current.pid();
    }

    @Override
    public JFRStats getJFRStats() {
        return this.jfrStats;
    }

    @Override
    protected native void rotate();

    @Override
    protected native void shutdown();

    @Override
    protected native void start(boolean var1);

    @Override
    protected native void stop();

    private native ByteBuffer buffer();

    private native void flush();

    private native void write(byte[] var1, int var2, int var3);

    private native void add(int var1, byte[] var2, int var3, int var4);

    private native void remove(int var1);

    native void setThreshold(int var1, long var2);

    native void setPeriod(int var1, long var2);

    native long getPeriod(int var1);

    native int descriptors(int var1, ByteBuffer[] var2);

    @Override
    protected void add(ProducerDescriptor producerDescriptor) {
        if (producerDescriptor == this.vm) {
            return;
        }
        ByteBuffer byteBuffer = producerDescriptor.getBinaryDescriptor();
        this.add(producerDescriptor.getId(), byteBuffer.array(), byteBuffer.arrayOffset(), byteBuffer.capacity());
    }

    @Override
    protected void remove(ProducerDescriptor producerDescriptor) {
        if (producerDescriptor == this.vm) {
            return;
        }
        this.remove(producerDescriptor.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishChunk(String string, long l, long l2, boolean bl) {
        RepositoryChunk repositoryChunk = new RepositoryChunk(this.logger, new File(string));
        try {
            repositoryChunk.finish(l, l2);
            this.addChunk(repositoryChunk);
        }
        catch (Exception exception) {
            this.logger.warn("VMJFR.finishChunk ignored an exception", exception);
        }
        finally {
            repositoryChunk.release();
            repositoryChunk = null;
            this.chunkDone();
        }
    }

    private String dumpRecording(String string, long l, String string2, boolean bl) throws DCmdException {
        DCmdDump dCmdDump = new DCmdDump(this);
        dCmdDump.execute(string, l, string2, bl);
        return dCmdDump.getResult();
    }

    private String stopRecording(String string, long l, boolean bl, String string2, boolean bl2) throws DCmdException {
        DCmdStop dCmdStop = new DCmdStop(this);
        dCmdStop.execute(string, l, bl, string2, bl2);
        return dCmdStop.getResult();
    }

    private String startRecording(String string, String[] stringArray, boolean bl, long l, long l2, String string2, boolean bl2, long l3, long l4, boolean bl3) throws DCmdException {
        DCmdStart dCmdStart = new DCmdStart(this);
        dCmdStart.execute(string, stringArray, bl, l, l2, string2, bl2, l3, l4, bl3);
        return dCmdStart.getResult();
    }

    private String checkRecording(String string, long l, boolean bl) throws DCmdException {
        DCmdCheck dCmdCheck = new DCmdCheck(this);
        dCmdCheck.execute(string, l, bl);
        return dCmdCheck.getResult();
    }

    static JFR create() throws Throwable {
        if (VMJFR.isCommercialFeaturesUnlocked() && VMJFR.isEnabled()) {
            return new VMJFR();
        }
        return null;
    }

    private static native boolean redefineClass0(Class<?> var0, byte[] var1);

    private static synchronized native void retransformClasses0(Class<?>[] var0);

    private byte[] retransformCallback(Class<?> clazz, byte[] byArray) throws Throwable {
        byte[] byArray2 = null;
        try {
            if (Throwable.class == clazz) {
                this.logger.trace("instrumenting java.lang.Throwable");
                return ThrowableInstrumentor.generateThrowableAsm(byArray);
            }
            if (Error.class == clazz) {
                this.logger.trace("instrumenting java.lang.Error");
                return ThrowableInstrumentor.generateErrorAsm(byArray);
            }
        }
        catch (Throwable throwable) {
            this.logger.error("Failure during class transformation:", throwable);
            throw throwable;
        }
        return byArray2;
    }

    void instrument() throws Exception {
        ThrowableTracer.enable(this, producer);
        ArrayList<Class> arrayList = new ArrayList<Class>();
        arrayList.add(Throwable.class);
        arrayList.add(Error.class);
        VMJFR.retransformClasses0(arrayList.toArray(new Class[arrayList.size()]));
        socketReadToken = producer.addEvent(SocketReadEvent.class);
        socketWriteToken = producer.addEvent(SocketWriteEvent.class);
        fileReadToken = producer.addEvent(FileReadEvent.class);
        fileWriteToken = producer.addEvent(FileWriteEvent.class);
        securityProviderToken = producer.addEvent(SecurityProviderServiceEvent.class);
        securityPropertyToken = producer.addEvent(SecurityPropertyModificationEvent.class);
        tlsHandshakeToken = producer.addEvent(TLSHandshakeEvent.class);
        x509CertificateToken = producer.addEvent(X509CertificateEvent.class);
        x509ValidationToken = producer.addEvent(X509ValidationEvent.class);
        Tracer.getInstance().addInstrumentations(Arrays.asList(this.instrumentationClasses), (Logger)new JILogAdapter());
    }

    private static Thread createJavaLangThreadForBufferthread(final ThreadGroup threadGroup, final ClassLoader classLoader) {
        Permission[] permissionArray = new RuntimePermission[]{new RuntimePermission("setContextClassLoader"), new RuntimePermission("modifyThread"), new RuntimePermission("modifyThreadGroup")};
        return AccessController.doPrivileged(new PrivilegedAction<Thread>(){

            @Override
            public Thread run() {
                Thread thread = new Thread(threadGroup, "VM JFR Buffer Thread");
                thread.setContextClassLoader(classLoader);
                return thread;
            }
        }, null, permissionArray);
    }

    class JILogAdapter
    implements Logger {
        JILogAdapter() {
        }

        public void error(String string) {
            VMJFR.this.logger.error(string);
        }

        public void warn(String string) {
            VMJFR.this.logger.warn(string);
        }

        public void info(String string) {
            VMJFR.this.logger.info(string);
        }

        public void debug(String string) {
            VMJFR.this.logger.debug(string);
        }

        public void trace(String string) {
            VMJFR.this.logger.trace(string);
        }

        public void error(String string, Throwable throwable) {
            VMJFR.this.logger.error(string, throwable);
        }
    }

    private final class ThreadBuffer {
        private final ByteBuffer base;
        private final ByteBuffer buffer;

        public ThreadBuffer(ByteBuffer byteBuffer) {
            this.base = byteBuffer.order(ByteOrder.nativeOrder());
            byteBuffer.position(DATA);
            this.buffer = byteBuffer.slice();
        }

        public void acquire() {
            this.base.put(USED, (byte)1);
        }

        public void release() {
            this.base.put(USED, (byte)0);
        }

        public void finish(ByteBuffer byteBuffer, boolean bl) {
            if (byteBuffer != this.buffer && bl) {
                byteBuffer.flip();
                VMJFR.this.write(byteBuffer.array(), byteBuffer.arrayOffset(), byteBuffer.limit());
                return;
            }
            if (bl) {
                int n = this.buffer.position();
                if (JFR.addressSize == 8) {
                    long l = this.base.getLong(START);
                    this.base.putLong(POS, l + (long)n);
                }
                if (JFR.addressSize == 4) {
                    int n2 = this.base.getInt(START);
                    this.base.putInt(POS, n2 + n);
                }
            }
            this.release();
        }

        public ByteBuffer ensure(int n) {
            int n2;
            assert (n != 0);
            if (this.buffer.capacity() < n) {
                return ByteBuffer.allocate(n + 512);
            }
            while (true) {
                this.acquire();
                if (JFR.addressSize == 8) {
                    long l;
                    long l2 = this.base.getLong(END);
                    if (l2 - (l = this.base.getLong(POS)) < (long)n) {
                        this.release();
                        VMJFR.this.flush();
                        continue;
                    }
                    int n3 = (int)(l - this.base.getLong(START));
                    this.buffer.position(n3);
                    return this.buffer;
                }
                if (JFR.addressSize != 4) continue;
                int n4 = this.base.getInt(END);
                if (n4 - (n2 = this.base.getInt(POS)) >= n) break;
                this.release();
                VMJFR.this.flush();
            }
            int n5 = n2 - this.base.getInt(START);
            this.buffer.position(n5);
            return this.buffer;
        }
    }
}

