/*
 * Decompiled with CFR 0.152.
 */
package oracle.jvm.hotspot.jfr;

import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.runtime.VM;

public final class JFRGlobalBuffer {
    Address buffer;
    Address start;
    Address end;
    Address pos;

    public JFRGlobalBuffer(Address addr) {
        this.buffer = addr;
        long addressSize = VM.getVM().getAddressSize();
        this.start = this.buffer.getAddressAt(0L * addressSize);
        this.end = this.buffer.getAddressAt(1L * addressSize);
        this.pos = this.buffer.getAddressAt(2L * addressSize);
    }

    public Address getStart() {
        return this.start;
    }

    public byte[] getBytesAtStart() {
        int size = (int)this.usedSize();
        byte[] buffer = new byte[size];
        for (int i = 0; i < size; ++i) {
            buffer[i] = this.start.getJByteAt(i);
        }
        return buffer;
    }

    public Address getEnd() {
        return this.end;
    }

    public Address getPos() {
        return this.pos;
    }

    public long usedSize() {
        return this.pos.minus(this.start);
    }

    public void resetBuffer() {
        this.pos = this.start;
    }
}

