/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.tools.packager;

import com.oracle.tools.packager.Bundler;
import com.oracle.tools.packager.BundlerParamInfo;
import com.oracle.tools.packager.IOUtils;
import com.oracle.tools.packager.Log;
import com.oracle.tools.packager.StandardBundlerParam;
import com.oracle.tools.packager.windows.WindowsBundlerParam;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Map;
import java.util.ResourceBundle;

public abstract class AbstractBundler
implements Bundler {
    private static final ResourceBundle I18N = ResourceBundle.getBundle(AbstractBundler.class.getName());
    public static final BundlerParamInfo<File> IMAGES_ROOT = new WindowsBundlerParam<File>(I18N.getString("param.images-root.name"), I18N.getString("param.images-root.description"), "imagesRoot", File.class, map -> new File((File)StandardBundlerParam.BUILD_ROOT.fetchFrom((Map<String, Object>)map), "images"), (string, map) -> null);
    public static final String BUNDLER_PREFIX = "package/";
    protected Class baseResourceLoader = null;

    protected void fetchResource(String string, String string2, String string3, File file, boolean bl, File file2) throws IOException {
        URL uRL = this.locateResource(string, string2, string3, bl, file2);
        if (uRL != null) {
            IOUtils.copyFromURL(uRL, file);
        } else if (bl) {
            Log.info(MessageFormat.format(I18N.getString("message.using-default-resource"), string2 == null ? "" : "[" + string2 + "] ", string));
        }
    }

    protected void fetchResource(String string, String string2, File file, File file2, boolean bl, File file3) throws IOException {
        URL uRL = this.locateResource(string, string2, null, bl, file3);
        if (uRL != null) {
            IOUtils.copyFromURL(uRL, file2);
        } else {
            IOUtils.copyFile(file, file2);
            if (bl) {
                Log.info(MessageFormat.format(I18N.getString("message.using-custom-resource-from-file"), string2 == null ? "" : "[" + string2 + "] ", file.getAbsoluteFile()));
            }
        }
    }

    private URL locateResource(String string, String string2, String string3, boolean bl, File file) throws IOException {
        Object object;
        URL uRL = null;
        boolean bl2 = false;
        if (string != null) {
            if (file != null) {
                object = new File(file, string);
                if (((File)object).exists() && ((File)object).isFile()) {
                    uRL = ((File)object).toURI().toURL();
                }
            } else {
                uRL = this.baseResourceLoader.getClassLoader().getResource(string);
            }
            boolean bl3 = bl2 = uRL != null;
        }
        if (uRL == null && string3 != null) {
            uRL = this.baseResourceLoader.getResource(string3);
        }
        object = null;
        if (bl2) {
            object = MessageFormat.format(I18N.getString("message.using-custom-resource-from-classpath"), string2 == null ? "" : "[" + string2 + "] ", string);
        } else if (uRL != null) {
            object = MessageFormat.format(I18N.getString("message.using-default-resource-from-classpath"), string2 == null ? "" : "[" + string2 + "] ", string);
        }
        if (bl && uRL != null) {
            Log.info((String)object);
        }
        return uRL;
    }

    protected String preprocessTextResource(String string, String string2, String string3, Map<String, String> map, boolean bl, File file) throws IOException {
        int n;
        URL uRL = this.locateResource(string, string2, string3, bl, file);
        InputStream inputStream = uRL.openStream();
        if (inputStream == null) {
            throw new RuntimeException("Jar corrupt? No " + string3 + " resource!");
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[1024];
        while ((n = inputStream.read(byArray)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        String string4 = new String(byteArrayOutputStream.toByteArray());
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (entry.getValue() == null) continue;
            string4 = string4.replace(entry.getKey(), entry.getValue());
        }
        return string4;
    }

    public String toString() {
        return this.getName();
    }
}

